/*
 * Decompiled with CFR 0.152.
 */
import go.GoBoundBox;
import go.GoColor;
import go.GoInterface;
import go.GoMatrix;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Vector;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;

public class MkRenderer3D
extends GoInterface {
    public static final GoColor cyan = new GoColor(0.0, 1.0, 1.0);
    public static final GoColor yellow = new GoColor(1.0, 1.0, 0.0);
    public static final GoColor green = new GoColor(0.0, 1.0, 0.0);
    public static final GoColor tomato = new GoColor(1.0, 0.39, 0.28);
    public static final GoColor cornflowerBlue = new GoColor(0.39, 0.58, 0.93);
    public static final GoColor orange = new GoColor(1.0, 0.65, 0.0);
    public static final GoColor lightGray = new GoColor(0.75, 0.75, 0.75);
    GoMatrix initialModelview;
    GoMatrix inversedModelview;
    GoMatrix tempMat;
    double radius;
    double diameter;
    double phi;
    double theta;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    double centerX;
    double centerY;
    double centerZ;
    double centerIsoX;
    double centerIsoY;
    double centerIsoZ;
    double radiusIso;
    double centerAnisoX;
    double centerAnisoY;
    double centerAnisoZ;
    double radiusAniso;
    int xStart;
    int yStart;
    int xEnd;
    int yEnd;
    double xLength;
    double yLength;
    double zLength;
    double largestLength;
    double scaleX;
    double scaleY;
    double scaleZ;
    GoBoundBox boundBox;
    MkGeomAxes3D geomAxes;
    double[] m;
    boolean isIsotropic;
    int i;
    JEP parser1;
    JEP parser2;
    JEP parser3;
    boolean graphIsEmpty;
    Vector scene;
    MkScientificFormat sf;
    Cursor normalCursor;
    Cursor selectCursor;

    MkRenderer3D() {
        this.boundBox = this.go.boundBox();
        this.isIsotropic = true;
        this.graphIsEmpty = false;
        this.scene = new Vector();
        this.sf = new MkScientificFormat();
        this.initialModelview = new GoMatrix();
        this.inversedModelview = new GoMatrix();
        this.tempMat = new GoMatrix();
        this.geomAxes = new MkGeomAxes3D();
        this.go.background(0.0, 0.0, 0.0);
        this.parser1 = new JEP();
        this.parser2 = new JEP();
        this.parser3 = new JEP();
        this.parser1.addStandardFunctions();
        this.parser1.addStandardConstants();
        this.parser2.addStandardFunctions();
        this.parser2.addStandardConstants();
        this.parser3.addStandardFunctions();
        this.parser3.addStandardConstants();
        this.normalCursor = new Cursor(0);
        this.selectCursor = new Cursor(12);
    }

    void calculateAll() throws IllegalExpressionException {
        this.calculatePoints();
        this.calculateBoundBox();
        this.calculateFixedPoints();
    }

    void calculateBoundBox() {
        this.go.matrixMode(65536);
        this.go.identity();
        this.go.renderMode(8);
        this.go.clear(8);
        this.i = 0;
        while (this.i < this.scene.size()) {
            Object e = this.scene.elementAt(this.i);
            if (e instanceof MkGeomVector3D) {
                ((MkGeomVector3D)e).render(this.go);
            } else if (e instanceof MkGeomLine3D) {
                ((MkGeomLine3D)e).render(this.go);
            } else if (e instanceof MkGeomCurve3D) {
                ((MkGeomCurve3D)e).render(this.go);
            } else if (e instanceof MkGeomSurface3D) {
                ((MkGeomSurface3D)e).render(this.go);
                ((MkGeomSurface3D)e).setBoundBox();
            } else if (e instanceof MkGeomWireSurface3D) {
                ((MkGeomWireSurface3D)e).render(this.go);
                ((MkGeomWireSurface3D)e).setBoundBox();
            } else if (e instanceof MkGeomPlaneOxy3D) {
                ((MkGeomPlaneOxy3D)e).render(this.go);
            } else if (e instanceof MkGeomPoint3D) {
                ((MkGeomPoint3D)e).render(this.go);
            }
            ++this.i;
        }
        this.setBounds();
    }

    void calculatePoints() throws IllegalExpressionException {
        this.i = 0;
        while (this.i < this.scene.size()) {
            Object e = this.scene.elementAt(this.i);
            if (e instanceof MkGeomVector3D) {
                ((MkGeomVector3D)e).calculatePoints();
            } else if (e instanceof MkGeomLine3D) {
                ((MkGeomLine3D)e).calculatePoints();
            } else if (e instanceof MkGeomCurve3D) {
                ((MkGeomCurve3D)e).calculatePoints(this.parser1, this.parser2, this.parser3);
            } else if (e instanceof MkGeomSurface3D) {
                ((MkGeomSurface3D)e).calculatePoints(this.parser1, this.parser2, this.parser3);
            } else if (e instanceof MkGeomWireSurface3D) {
                ((MkGeomWireSurface3D)e).calculatePoints(this.parser1, this.parser2, this.parser3);
            } else if (e instanceof MkGeomPlaneOxy3D) {
                ((MkGeomPlaneOxy3D)e).calculatePoints();
            }
            ++this.i;
        }
    }

    void calculateFixedPoints() throws IllegalExpressionException {
        if (this.isIsotropic) {
            this.i = 0;
            while (this.i < this.scene.size()) {
                Object e = this.scene.elementAt(this.i);
                this.diameter = 2.0 * this.radiusIso;
                if (e instanceof MkGeomVector3D) {
                    ((MkGeomVector3D)e).calculateHead(1.0, 1.0, 1.0, this.diameter);
                } else if (e instanceof MkGeomPoint3D) {
                    ((MkGeomPoint3D)e).calculatePoints(this.parser1, this.parser2, this.parser3, 1.0, 1.0, 1.0, this.diameter);
                } else if (e instanceof MkGeomText3D) {
                    ((MkGeomText3D)e).calculatePoints(1.0, 1.0, 1.0, this.diameter);
                }
                ++this.i;
            }
            this.geomAxes.calculatePoints(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, 1.0, 1.0, 1.0, this.diameter);
            return;
        }
        this.diameter = 2.0 * this.radiusAniso;
        this.i = 0;
        while (this.i < this.scene.size()) {
            Object e = this.scene.elementAt(this.i);
            if (e instanceof MkGeomVector3D) {
                ((MkGeomVector3D)e).calculateHead(this.scaleX, this.scaleY, this.scaleZ, this.diameter);
            } else if (e instanceof MkGeomPoint3D) {
                ((MkGeomPoint3D)e).calculatePoints(this.parser1, this.parser2, this.parser3, this.scaleX, this.scaleY, this.scaleZ, this.diameter);
            } else if (e instanceof MkGeomText3D) {
                ((MkGeomText3D)e).calculatePoints(this.scaleX, this.scaleY, this.scaleZ, this.diameter);
            }
            ++this.i;
        }
        this.geomAxes.calculatePoints(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.scaleX, this.scaleY, this.scaleZ, this.diameter);
    }

    void setBounds() {
        this.xMin = this.boundBox.xMin();
        this.xMax = this.boundBox.xMax();
        this.yMin = this.boundBox.yMin();
        this.yMax = this.boundBox.yMax();
        this.zMin = this.boundBox.zMin();
        this.zMax = this.boundBox.zMax();
        this.centerIsoX = (this.xMin + this.xMax) / 2.0;
        this.centerIsoY = (this.yMin + this.yMax) / 2.0;
        this.centerIsoZ = (this.zMin + this.zMax) / 2.0;
        this.radiusIso = this.distance(this.centerIsoX, this.centerIsoY, this.centerIsoZ, this.xMax, this.yMax, this.zMax);
        this.xLength = this.xMax - this.xMin;
        this.yLength = this.yMax - this.yMin;
        this.zLength = this.zMax - this.zMin;
        this.largestLength = this.xLength;
        if (this.yLength > this.largestLength) {
            this.largestLength = this.yLength;
        }
        if (this.zLength > this.largestLength) {
            this.largestLength = this.zLength;
        }
        this.scaleX = this.xLength != 0.0 ? this.largestLength / this.xLength : 1.0;
        this.scaleY = this.yLength != 0.0 ? this.largestLength / this.yLength : 1.0;
        this.scaleZ = this.zLength != 0.0 ? this.largestLength / this.zLength : 1.0;
        this.centerAnisoX = this.centerIsoX * this.scaleX;
        this.centerAnisoY = this.centerIsoY * this.scaleY;
        this.centerAnisoZ = this.centerIsoZ * this.scaleZ;
        this.radiusAniso = this.distance(this.centerAnisoX, this.centerAnisoY, this.centerAnisoZ, this.scaleX * this.xMax, this.scaleY * this.yMax, this.scaleZ * this.zMax);
    }

    public void modelview() {
        this.go.matrixMode(65536);
        this.go.identity();
        this.go.rotate(-90.0, 1.0, 0.0, 0.0);
        this.go.rotate(-90.0, 0.0, 0.0, 1.0);
        this.go.rotate(45.0, 0.0, 1.0, 0.0);
        this.go.rotate(-45.0, 0.0, 0.0, 1.0);
        this.go.getModelview(this.initialModelview);
        this.go.getModelview(this.tempMat);
        if (this.isIsotropic) {
            this.go.identity();
            this.go.translate(this.centerIsoX, this.centerIsoY, this.centerIsoZ);
            this.go.multiply(this.tempMat);
            this.go.translate(-this.centerIsoX, -this.centerIsoY, -this.centerIsoZ);
            return;
        }
        this.go.identity();
        this.go.translate(this.centerAnisoX, this.centerAnisoY, this.centerAnisoZ);
        this.go.multiply(this.tempMat);
        this.go.translate(-this.centerAnisoX, -this.centerAnisoY, -this.centerAnisoZ);
        this.go.scale(this.scaleX, this.scaleY, this.scaleZ);
    }

    public void projection() {
        this.go.width();
        this.go.height();
        if (this.isIsotropic) {
            this.radius = this.radiusIso;
            this.centerX = this.centerIsoX;
            this.centerY = this.centerIsoY;
            this.centerZ = this.centerIsoZ;
        } else {
            this.radius = this.radiusAniso;
            this.centerX = this.centerAnisoX;
            this.centerY = this.centerAnisoY;
            this.centerZ = this.centerAnisoZ;
        }
        double d = this.radius;
        double d2 = this.radius;
        double d3 = 600.0 * this.radius;
        this.go.matrixMode(131072);
        this.go.identity();
        this.go.ortho(this.centerX - d, this.centerX + d, this.centerY - d2, this.centerY + d2, this.centerZ - d3, this.centerZ + d3);
        this.go.matrixMode(65536);
    }

    public void resized(int n, int n2) {
        this.modelview();
        this.projection();
    }

    public void mousePressedNew(int n, int n2) {
        this.xStart = n;
        this.yStart = n2;
        this.go.matrixMode(65536);
        this.go.load(this.tempMat);
        this.go.getModelview(this.initialModelview);
        this.go.inverse();
        this.go.getModelview(this.inversedModelview);
        this.m = this.inversedModelview.m;
    }

    public void mouseReleasedNew(int n, int n2) {
        this.xEnd = n;
        this.yEnd = n2;
        this.rotateHorizVert();
    }

    public void mouseEnteredNew(int n, int n2) {
        ((Component)((Object)this)).setCursor(this.selectCursor);
    }

    public void mouseExitedNew(int n, int n2) {
        ((Component)((Object)this)).setCursor(this.normalCursor);
    }

    public void mouseDraggedNew(int n, int n2) {
        this.xEnd = n;
        this.yEnd = n2;
        this.rotateHorizVert();
    }

    double distance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 - d;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        return Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9);
    }

    public void rotateHorizVert() {
        this.theta = 180 * (this.xEnd - this.xStart) / this.go.width();
        this.phi = 180 * (this.yEnd - this.yStart) / this.go.height();
        this.go.load(this.initialModelview);
        this.go.rotate(this.phi, this.m[0], this.m[1], this.m[2]);
        this.go.rotate(this.theta, this.m[4], this.m[5], this.m[6]);
        this.go.getModelview(this.tempMat);
        this.go.identity();
        this.go.translate(this.centerX, this.centerY, this.centerZ);
        this.go.multiply(this.tempMat);
        this.go.translate(-this.centerX, -this.centerY, -this.centerZ);
        if (!this.isIsotropic) {
            this.go.scale(this.scaleX, this.scaleY, this.scaleZ);
        }
        this.render();
    }

    public void drawEmptyPlot() {
        this.graphIsEmpty = true;
        this.scene.removeAllElements();
        this.go.renderMode(1);
        this.go.clear(1);
        this.swap();
    }
}

