/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import org.nfunk.jep.type.Complex;

public class MkScientificFormat {
    protected static final double LOG10SCALE = 1.0 / Math.log(10.0);
    private int accuracy = 2;
    private double sciMult = 100.0;
    private double minNoExp = 0.01;
    private double maxNoExp = 100.0;
    private NumberFormat nf = NumberFormat.getInstance();

    public MkScientificFormat() {
        this.nf.setMinimumFractionDigits(0);
        this.nf.setMaximumFractionDigits(2);
    }

    public void setAccuracy(int n) {
        this.accuracy = n;
        this.sciMult = Math.pow(10.0, n);
        this.nf.setMinimumFractionDigits(n);
        this.nf.setMaximumFractionDigits(n);
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setMinNoExp(double d) {
        this.minNoExp = d;
    }

    public double getMinNoExp() {
        return this.minNoExp;
    }

    public void setMaxNoExp(double d) {
        this.maxNoExp = d;
    }

    public double getMaxNoExp() {
        return this.maxNoExp;
    }

    public String formatReg(double d) {
        if (Double.isInfinite(d)) {
            if (d == Double.NEGATIVE_INFINITY) {
                return "-Inf";
            }
            return "+Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        d = Math.round(d * this.sciMult);
        return this.nf.format(d /= this.sciMult);
    }

    public String formatPure(double d) {
        if (Double.isInfinite(d)) {
            if (d == Double.NEGATIVE_INFINITY) {
                return "-Inf";
            }
            return "+Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        int n = this.getExponent(d);
        d *= Math.pow(10.0, -n);
        d = Math.round(d * this.sciMult);
        d /= this.sciMult;
        if (n != 0) {
            return String.valueOf(this.nf.format(d)) + "E" + Integer.toString(n);
        }
        return this.nf.format(d);
    }

    public String format(double d) {
        if (Double.isInfinite(d)) {
            if (d == Double.NEGATIVE_INFINITY) {
                return "-Inf";
            }
            return "+Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        double d2 = Math.abs(d);
        if (d2 > this.minNoExp && d2 < this.maxNoExp) {
            return this.formatReg(d);
        }
        return this.formatPure(d);
    }

    public String formatComplex(Complex complex) {
        double d = complex.re();
        double d2 = complex.im();
        String string = d != 0.0 ? (d2 == -1.0 ? String.valueOf(this.format(d)) + "-i" : (d2 == 1.0 ? String.valueOf(this.format(d)) + "+i" : (d2 == 0.0 ? this.format(d) : (d2 > 0.0 ? String.valueOf(this.format(d)) + "+" + this.format(d2) + "*i" : String.valueOf(this.format(d)) + this.format(d2) + "*i")))) : (d2 == -1.0 ? "-i" : (d2 == 1.0 ? "i" : (d2 == 0.0 ? this.format(d) : String.valueOf(this.format(d2)) + "*i")));
        return string;
    }

    public int numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    public int numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    public int getExponent(double d) {
        if (d == 0.0) {
            return 0;
        }
        return (int)Math.floor(Math.log(Math.abs(d)) * LOG10SCALE);
    }
}

