/*
 * Decompiled with CFR 0.152.
 */
public class MkVector2d
extends MkTuple2d {
    public MkVector2d() {
    }

    public MkVector2d(double d, double d2) {
        super(d, d2);
    }

    public MkVector2d(double d, double d2, double d3, double d4) {
        super(d3 - d, d4 - d2);
    }

    public MkVector2d(MkPoint2d mkPoint2d, MkPoint2d mkPoint2d2) {
        super(mkPoint2d2.x - mkPoint2d.x, mkPoint2d2.y - mkPoint2d.y);
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize(MkVector2d mkVector2d) {
        this.set(mkVector2d);
        this.normalize();
    }

    public void normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
        }
    }

    public double dot(MkVector2d mkVector2d) {
        return this.x * mkVector2d.x + this.y * mkVector2d.y;
    }

    public double dot(MkVector2d mkVector2d, MkVector2d mkVector2d2) {
        return mkVector2d.x * mkVector2d2.x + mkVector2d.y * mkVector2d2.y;
    }

    public double angleWithRadians(MkVector2d mkVector2d) {
        double d = this.magnitude();
        double d2 = mkVector2d.magnitude();
        if (d != 0.0 && d2 != 0.0) {
            return Math.acos(this.dot(mkVector2d) / (d * d2));
        }
        return 0.0;
    }

    public double angleWithDegrees(MkVector2d mkVector2d) {
        return MkMath.radToDeg(this.angleWithRadians(mkVector2d));
    }

    public double angleWithXRadians() {
        return Math.atan2(this.y, this.x);
    }

    public double angleWithXDegrees() {
        return MkMath.radToDeg(this.angleWithXRadians());
    }

    public void projection(MkVector2d mkVector2d, MkVector2d mkVector2d2) {
        this.normalize(mkVector2d2);
        this.scale(this.dot(mkVector2d));
    }
}

