/*
 * Decompiled with CFR 0.152.
 */
public final class Sort {
    private static final int CUTOFF = 3;

    public static void quicksort(double[] dArray) {
        Sort.quicksort(dArray, 0, dArray.length - 1);
    }

    public static final void swapReferences(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static double median3(double[] dArray, int n, int n2) {
        int n3 = (n + n2) / 2;
        if (dArray[n3] < dArray[n]) {
            Sort.swapReferences(dArray, n, n3);
        }
        if (dArray[n2] < dArray[n]) {
            Sort.swapReferences(dArray, n, n2);
        }
        if (dArray[n2] < dArray[n3]) {
            Sort.swapReferences(dArray, n3, n2);
        }
        Sort.swapReferences(dArray, n3, n2 - 1);
        return dArray[n2 - 1];
    }

    private static void quicksort(double[] dArray, int n, int n2) {
        if (n + 3 <= n2) {
            double d = Sort.median3(dArray, n, n2);
            int n3 = n;
            int n4 = n2 - 1;
            while (true) {
                if (dArray[++n3] < d) {
                    continue;
                }
                while (dArray[--n4] > d) {
                }
                if (n3 >= n4) break;
                Sort.swapReferences(dArray, n3, n4);
            }
            Sort.swapReferences(dArray, n3, n2 - 1);
            Sort.quicksort(dArray, n, n3 - 1);
            Sort.quicksort(dArray, n3 + 1, n2);
            return;
        }
        Sort.insertionSort(dArray, n, n2);
    }

    private static void insertionSort(double[] dArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            double d = dArray[n3];
            int n4 = n3;
            while (n4 > n && d < dArray[n4 - 1]) {
                dArray[n4] = dArray[n4 - 1];
                --n4;
            }
            dArray[n4] = d;
            ++n3;
        }
    }

    public static void quickSelect(double[] dArray, int n) {
        Sort.quickSelect(dArray, 0, dArray.length - 1, n);
    }

    private static void quickSelect(double[] dArray, int n, int n2, int n3) {
        if (n + 3 <= n2) {
            double d = Sort.median3(dArray, n, n2);
            int n4 = n;
            int n5 = n2 - 1;
            while (true) {
                if (dArray[++n4] < d) {
                    continue;
                }
                while (dArray[--n5] > d) {
                }
                if (n4 >= n5) break;
                Sort.swapReferences(dArray, n4, n5);
            }
            Sort.swapReferences(dArray, n4, n2 - 1);
            if (n3 <= n4) {
                Sort.quickSelect(dArray, n, n4 - 1, n3);
                return;
            }
            if (n3 > n4 + 1) {
                Sort.quickSelect(dArray, n4 + 1, n2, n3);
                return;
            }
        } else {
            Sort.insertionSort(dArray, n, n2);
        }
    }
}

