/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Daxpy;
import org.netlib.blas.Dcopy;
import org.netlib.blas.Dgbmv;
import org.netlib.lapack.Dgbtrs;
import org.netlib.lapack.Dlacon;
import org.netlib.lapack.Dlamch;
import org.netlib.util.Xerbla;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Dgbrfs {
    static int itmax = 5;
    static double zero;
    static double one;
    static double two;
    static double three;
    static boolean notran;
    static String transt;
    static int count;
    static int i;
    static int j;
    static int k;
    static intW kase;
    static int kk;
    static int nz;
    static double eps;
    static double lstres;
    static double s;
    static double safe1;
    static double safe2;
    static double safmin;
    static double xk;

    public static void dgbrfs(String string, int n, int n2, int n3, int n4, double[] dArray, int n5, int n6, double[] dArray2, int n7, int n8, int[] nArray, int n9, double[] dArray3, int n10, int n11, double[] dArray4, int n12, int n13, double[] dArray5, int n14, double[] dArray6, int n15, double[] dArray7, int n16, int[] nArray2, int n17, intW intW2) {
        intW2.val = 0;
        boolean bl = notran = string.toLowerCase().charAt(0) == "N".toLowerCase().charAt(0);
        if (!notran && string.toLowerCase().charAt(0) != "T".toLowerCase().charAt(0) && string.toLowerCase().charAt(0) != "C".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (n < 0) {
            intW2.val = -2;
        } else if (n2 < 0) {
            intW2.val = -3;
        } else if (n3 < 0) {
            intW2.val = -4;
        } else if (n4 < 0) {
            intW2.val = -5;
        } else if (n6 < n2 + n3 + 1) {
            intW2.val = -7;
        } else if (n8 < 2 * n2 + n3 + 1) {
            intW2.val = -9;
        } else if (n11 < Math.max(1, n)) {
            intW2.val = -12;
        } else if (n13 < Math.max(1, n)) {
            intW2.val = -14;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DGBRFS", -intW2.val);
        } else if (n == 0 || n4 == 0) {
            j = 1;
            while (j <= n4) {
                dArray5[Dgbrfs.j - 1 + n14] = zero;
                dArray6[Dgbrfs.j - 1 + n15] = zero;
                ++j;
            }
        } else {
            transt = notran ? "T" : "N";
            nz = Math.min(n2 + n3 + 2, n + 1);
            eps = Dlamch.dlamch("Epsilon");
            safmin = Dlamch.dlamch("Safe minimum");
            safe1 = (double)nz * safmin;
            safe2 = safe1 / eps;
            j = 1;
            while (j <= n4) {
                count = 1;
                lstres = three;
                while (true) {
                    Dcopy.dcopy(n, dArray3, (j - 1) * n11 + n10, 1, dArray7, n + 1 - 1 + n16, 1);
                    Dgbmv.dgbmv(string, n, n, n2, n3, -one, dArray, n5, n6, dArray4, (j - 1) * n13 + n12, 1, one, dArray7, n + 1 - 1 + n16, 1);
                    i = 1;
                    while (i <= n) {
                        dArray7[Dgbrfs.i - 1 + n16] = Math.abs(dArray3[i - 1 + (j - 1) * n11 + n10]);
                        ++i;
                    }
                    if (notran) {
                        k = 1;
                        while (k <= n) {
                            kk = n3 + 1 - k;
                            xk = Math.abs(dArray4[k - 1 + (j - 1) * n13 + n12]);
                            i = Math.max(1, k - n3);
                            while (i <= Math.min(n, k + n2)) {
                                dArray7[Dgbrfs.i - 1 + n16] = dArray7[i - 1 + n16] + Math.abs(dArray[kk + i - 1 + (k - 1) * n6 + n5]) * xk;
                                ++i;
                            }
                            ++k;
                        }
                    } else {
                        k = 1;
                        while (k <= n) {
                            s = zero;
                            kk = n3 + 1 - k;
                            i = Math.max(1, k - n3);
                            while (i <= Math.min(n, k + n2)) {
                                s += Math.abs(dArray[kk + i - 1 + (k - 1) * n6 + n5]) * Math.abs(dArray4[i - 1 + (j - 1) * n13 + n12]);
                                ++i;
                            }
                            dArray7[Dgbrfs.k - 1 + n16] = dArray7[k - 1 + n16] + s;
                            ++k;
                        }
                    }
                    s = zero;
                    i = 1;
                    while (i <= n) {
                        s = dArray7[i - 1 + n16] > safe2 ? Math.max(s, Math.abs(dArray7[n + i - 1 + n16]) / dArray7[i - 1 + n16]) : Math.max(s, (Math.abs(dArray7[n + i - 1 + n16]) + safe1) / (dArray7[i - 1 + n16] + safe1));
                        ++i;
                    }
                    dArray6[Dgbrfs.j - 1 + n15] = s;
                    if (!(dArray6[j - 1 + n15] > eps) || !(two * dArray6[j - 1 + n15] <= lstres) || count > itmax) break;
                    Dgbtrs.dgbtrs(string, n, n2, n3, 1, dArray2, n7, n8, nArray, n9, dArray7, n + 1 - 1 + n16, n, intW2);
                    Daxpy.daxpy(n, one, dArray7, n + 1 - 1 + n16, 1, dArray4, (j - 1) * n13 + n12, 1);
                    lstres = dArray6[j - 1 + n15];
                    ++count;
                }
                i = 1;
                while (i <= n) {
                    dArray7[Dgbrfs.i - 1 + n16] = dArray7[i - 1 + n16] > safe2 ? Math.abs(dArray7[n + i - 1 + n16]) + (double)nz * eps * dArray7[i - 1 + n16] : Math.abs(dArray7[n + i - 1 + n16]) + (double)nz * eps * dArray7[i - 1 + n16] + safe1;
                    ++i;
                }
                Dgbrfs.kase.val = 0;
                block10: while (true) {
                    Dgbrfs.dlacon_adapter(n, dArray7, 2 * n + 1 - 1 + n16, dArray7, n + 1 - 1 + n16, nArray2, n17, dArray5, j - 1 + n14, kase);
                    if (Dgbrfs.kase.val == 0) break;
                    if (Dgbrfs.kase.val == 1) {
                        Dgbtrs.dgbtrs(transt, n, n2, n3, 1, dArray2, n7, n8, nArray, n9, dArray7, n + 1 - 1 + n16, n, intW2);
                        i = 1;
                        while (true) {
                            if (i > n) continue block10;
                            dArray7[n + Dgbrfs.i - 1 + n16] = dArray7[n + i - 1 + n16] * dArray7[i - 1 + n16];
                            ++i;
                        }
                    }
                    i = 1;
                    while (i <= n) {
                        dArray7[n + Dgbrfs.i - 1 + n16] = dArray7[n + i - 1 + n16] * dArray7[i - 1 + n16];
                        ++i;
                    }
                    Dgbtrs.dgbtrs(string, n, n2, n3, 1, dArray2, n7, n8, nArray, n9, dArray7, n + 1 - 1 + n16, n, intW2);
                }
                lstres = zero;
                i = 1;
                while (i <= n) {
                    lstres = Math.max(lstres, Math.abs(dArray4[i - 1 + (j - 1) * n13 + n12]));
                    ++i;
                }
                if (lstres != zero) {
                    dArray5[Dgbrfs.j - 1 + n14] = dArray5[j - 1 + n14] / lstres;
                }
                ++j;
            }
        }
    }

    private static void dlacon_adapter(int n, double[] dArray, int n2, double[] dArray2, int n3, int[] nArray, int n4, double[] dArray3, int n5, intW intW2) {
        doubleW doubleW2 = new doubleW(dArray3[n5]);
        Dlacon.dlacon(n, dArray, n2, dArray2, n3, nArray, n4, doubleW2, intW2);
        dArray3[n5] = doubleW2.val;
    }

    static {
        one = 1.0;
        two = 2.0;
        three = 3.0;
        transt = new String(" ");
        kase = new intW(0);
    }
}

