/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dgemm;
import org.netlib.lapack.Dgehd2;
import org.netlib.lapack.Dlahrd;
import org.netlib.lapack.Dlarfb;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dgehrd {
    static int nbmax = 64;
    static int ldt = nbmax + 1;
    static double zero;
    static double one;
    static int i;
    static int ib;
    static intW iinfo;
    static int iws;
    static int ldwork;
    static int nb;
    static int nbmin;
    static int nh;
    static int nx;
    static double ei;
    static double[] t;

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static void dgehrd(int n, int n2, int n3, double[] dArray, int n4, int n5, double[] dArray2, int n6, double[] dArray3, int n7, int n8, intW intW2) {
        intW2.val = 0;
        if (n < 0) {
            intW2.val = -1;
        } else if (n2 < 1 || n2 > Math.max(1, n)) {
            intW2.val = -2;
        } else if (n3 < Math.min(n2, n) || n3 > n) {
            intW2.val = -3;
        } else if (n5 < Math.max(1, n)) {
            intW2.val = -5;
        } else if (n8 < Math.max(1, n)) {
            intW2.val = -8;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DGEHRD", -intW2.val);
            return;
        }
        i = 1;
        while (i <= n2 - 1) {
            dArray2[Dgehrd.i - 1 + n6] = zero;
            ++i;
        }
        i = Math.max(1, n3);
        while (i <= n - 1) {
            dArray2[Dgehrd.i - 1 + n6] = zero;
            ++i;
        }
        nh = n3 - n2 + 1;
        if (nh <= 1) {
            dArray3[n7] = 1.0;
            return;
        }
        nb = Math.min(nbmax, Ilaenv.ilaenv(1, "DGEHRD", " ", n, n2, n3, -1));
        nbmin = 2;
        iws = 1;
        if (nb > 1 && nb < nh && (nx = Math.max(nb, Ilaenv.ilaenv(3, "DGEHRD", " ", n, n2, n3, -1))) < nh && n8 < (iws = n * nb)) {
            nbmin = Math.max(2, Ilaenv.ilaenv(2, "DGEHRD", " ", n, n2, n3, -1));
            nb = n8 >= n * nbmin ? n8 / n : 1;
        }
        ldwork = n;
        if (nb < nbmin || nb >= nh) {
            i = n2;
        } else {
            int n9 = nb;
            i = n2;
            boolean bl = true;
            while (true) {
                boolean bl2;
                if (!bl || (bl = false) || !true) {
                    ib = Math.min(nb, n3 - i);
                    Dlahrd.dlahrd(n3, i, ib, dArray, (i - 1) * n5 + n4, n5, dArray2, i - 1 + n6, t, 0, ldt, dArray3, n7, ldwork);
                    ei = dArray[i + ib - 1 + (i + ib - 1 - 1) * n5 + n4];
                    dArray[Dgehrd.i + Dgehrd.ib - 1 + (Dgehrd.i + Dgehrd.ib - 1 - 1) * n5 + n4] = one;
                    Dgemm.dgemm("No transpose", "Transpose", n3, n3 - i - ib + 1, ib, -one, dArray3, n7, ldwork, dArray, i + ib - 1 + (i - 1) * n5 + n4, n5, one, dArray, (i + ib - 1) * n5 + n4, n5);
                    dArray[Dgehrd.i + Dgehrd.ib - 1 + (Dgehrd.i + Dgehrd.ib - 1 - 1) * n5 + n4] = ei;
                    Dlarfb.dlarfb("Left", "Transpose", "Forward", "Columnwise", n3 - i, n - i - ib + 1, ib, dArray, i + 1 - 1 + (i - 1) * n5 + n4, n5, t, 0, ldt, dArray, i + 1 - 1 + (i + ib - 1) * n5 + n4, n5, dArray3, n7, ldwork);
                    i += n9;
                }
                if (n9 < 0) {
                    if (i >= n3 - 1 - nx) continue;
                    bl2 = false;
                } else {
                    if (i <= n3 - 1 - nx) continue;
                    bl2 = false;
                }
                if (!bl2) break;
            }
        }
        Dgehd2.dgehd2(n, i, n3, dArray, n4, n5, dArray2, n6, dArray3, n7, iinfo);
        dArray3[n7] = iws;
    }

    static {
        one = 1.0;
        iinfo = new intW(0);
        t = new double[ldt * nbmax];
    }
}

