/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Daxpy;
import org.netlib.blas.Dcopy;
import org.netlib.lapack.Dgttrs;
import org.netlib.lapack.Dlacon;
import org.netlib.lapack.Dlagtm;
import org.netlib.lapack.Dlamch;
import org.netlib.util.Xerbla;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Dgtrfs {
    static int itmax = 5;
    static double zero;
    static double one;
    static double two;
    static double three;
    static boolean notran;
    static String transn;
    static String transt;
    static int count;
    static int i;
    static int j;
    static intW kase;
    static int nz;
    static double eps;
    static double lstres;
    static double s;
    static double safe1;
    static double safe2;
    static double safmin;

    public static void dgtrfs(String string, int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, double[] dArray3, int n5, double[] dArray4, int n6, double[] dArray5, int n7, double[] dArray6, int n8, double[] dArray7, int n9, int[] nArray, int n10, double[] dArray8, int n11, int n12, double[] dArray9, int n13, int n14, double[] dArray10, int n15, double[] dArray11, int n16, double[] dArray12, int n17, int[] nArray2, int n18, intW intW2) {
        intW2.val = 0;
        boolean bl = notran = string.toLowerCase().charAt(0) == "N".toLowerCase().charAt(0);
        if (!notran && string.toLowerCase().charAt(0) != "T".toLowerCase().charAt(0) && string.toLowerCase().charAt(0) != "C".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (n < 0) {
            intW2.val = -2;
        } else if (n2 < 0) {
            intW2.val = -3;
        } else if (n12 < Math.max(1, n)) {
            intW2.val = -13;
        } else if (n14 < Math.max(1, n)) {
            intW2.val = -15;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DGTRFS", -intW2.val);
        } else if (n == 0 || n2 == 0) {
            j = 1;
            while (j <= n2) {
                dArray10[Dgtrfs.j - 1 + n15] = zero;
                dArray11[Dgtrfs.j - 1 + n16] = zero;
                ++j;
            }
        } else {
            if (notran) {
                transn = "N";
                transt = "T";
            } else {
                transn = "T";
                transt = "N";
            }
            nz = 4;
            eps = Dlamch.dlamch("Epsilon");
            safmin = Dlamch.dlamch("Safe minimum");
            safe1 = (double)nz * safmin;
            safe2 = safe1 / eps;
            j = 1;
            while (j <= n2) {
                count = 1;
                lstres = three;
                while (true) {
                    Dcopy.dcopy(n, dArray8, (j - 1) * n12 + n11, 1, dArray12, n + 1 - 1 + n17, 1);
                    Dlagtm.dlagtm(string, n, 1, -one, dArray, n3, dArray2, n4, dArray3, n5, dArray9, (j - 1) * n14 + n13, n14, one, dArray12, n + 1 - 1 + n17, n);
                    if (notran) {
                        if (n == 1) {
                            dArray12[n17] = Math.abs(dArray8[(j - 1) * n12 + n11]) + Math.abs(dArray2[n4] * dArray9[(j - 1) * n14 + n13]);
                        } else {
                            dArray12[n17] = Math.abs(dArray8[(j - 1) * n12 + n11]) + Math.abs(dArray2[n4] * dArray9[(j - 1) * n14 + n13]) + Math.abs(dArray3[n5] * dArray9[1 + (j - 1) * n14 + n13]);
                            i = 2;
                            while (i <= n - 1) {
                                dArray12[Dgtrfs.i - 1 + n17] = Math.abs(dArray8[i - 1 + (j - 1) * n12 + n11]) + Math.abs(dArray[i - 1 - 1 + n3] * dArray9[i - 1 - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray2[i - 1 + n4] * dArray9[i - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray3[i - 1 + n5] * dArray9[i + 1 - 1 + (j - 1) * n14 + n13]);
                                ++i;
                            }
                            dArray12[n - 1 + n17] = Math.abs(dArray8[n - 1 + (j - 1) * n12 + n11]) + Math.abs(dArray[n - 1 - 1 + n3] * dArray9[n - 1 - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray2[n - 1 + n4] * dArray9[n - 1 + (j - 1) * n14 + n13]);
                        }
                    } else if (n == 1) {
                        dArray12[n17] = Math.abs(dArray8[(j - 1) * n12 + n11]) + Math.abs(dArray2[n4] * dArray9[(j - 1) * n14 + n13]);
                    } else {
                        dArray12[n17] = Math.abs(dArray8[(j - 1) * n12 + n11]) + Math.abs(dArray2[n4] * dArray9[(j - 1) * n14 + n13]) + Math.abs(dArray[n3] * dArray9[1 + (j - 1) * n14 + n13]);
                        i = 2;
                        while (i <= n - 1) {
                            dArray12[Dgtrfs.i - 1 + n17] = Math.abs(dArray8[i - 1 + (j - 1) * n12 + n11]) + Math.abs(dArray3[i - 1 - 1 + n5] * dArray9[i - 1 - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray2[i - 1 + n4] * dArray9[i - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray[i - 1 + n3] * dArray9[i + 1 - 1 + (j - 1) * n14 + n13]);
                            ++i;
                        }
                        dArray12[n - 1 + n17] = Math.abs(dArray8[n - 1 + (j - 1) * n12 + n11]) + Math.abs(dArray3[n - 1 - 1 + n5] * dArray9[n - 1 - 1 + (j - 1) * n14 + n13]) + Math.abs(dArray2[n - 1 + n4] * dArray9[n - 1 + (j - 1) * n14 + n13]);
                    }
                    s = zero;
                    i = 1;
                    while (i <= n) {
                        s = dArray12[i - 1 + n17] > safe2 ? Math.max(s, Math.abs(dArray12[n + i - 1 + n17]) / dArray12[i - 1 + n17]) : Math.max(s, (Math.abs(dArray12[n + i - 1 + n17]) + safe1) / (dArray12[i - 1 + n17] + safe1));
                        ++i;
                    }
                    dArray11[Dgtrfs.j - 1 + n16] = s;
                    if (!(dArray11[j - 1 + n16] > eps) || !(two * dArray11[j - 1 + n16] <= lstres) || count > itmax) break;
                    Dgttrs.dgttrs(string, n, 1, dArray4, n6, dArray5, n7, dArray6, n8, dArray7, n9, nArray, n10, dArray12, n + 1 - 1 + n17, n, intW2);
                    Daxpy.daxpy(n, one, dArray12, n + 1 - 1 + n17, 1, dArray9, (j - 1) * n14 + n13, 1);
                    lstres = dArray11[j - 1 + n16];
                    ++count;
                }
                i = 1;
                while (i <= n) {
                    dArray12[Dgtrfs.i - 1 + n17] = dArray12[i - 1 + n17] > safe2 ? Math.abs(dArray12[n + i - 1 + n17]) + (double)nz * eps * dArray12[i - 1 + n17] : Math.abs(dArray12[n + i - 1 + n17]) + (double)nz * eps * dArray12[i - 1 + n17] + safe1;
                    ++i;
                }
                Dgtrfs.kase.val = 0;
                block7: while (true) {
                    Dgtrfs.dlacon_adapter(n, dArray12, 2 * n + 1 - 1 + n17, dArray12, n + 1 - 1 + n17, nArray2, n18, dArray10, j - 1 + n15, kase);
                    if (Dgtrfs.kase.val == 0) break;
                    if (Dgtrfs.kase.val == 1) {
                        Dgttrs.dgttrs(transt, n, 1, dArray4, n6, dArray5, n7, dArray6, n8, dArray7, n9, nArray, n10, dArray12, n + 1 - 1 + n17, n, intW2);
                        i = 1;
                        while (true) {
                            if (i > n) continue block7;
                            dArray12[n + Dgtrfs.i - 1 + n17] = dArray12[i - 1 + n17] * dArray12[n + i - 1 + n17];
                            ++i;
                        }
                    }
                    i = 1;
                    while (i <= n) {
                        dArray12[n + Dgtrfs.i - 1 + n17] = dArray12[i - 1 + n17] * dArray12[n + i - 1 + n17];
                        ++i;
                    }
                    Dgttrs.dgttrs(transn, n, 1, dArray4, n6, dArray5, n7, dArray6, n8, dArray7, n9, nArray, n10, dArray12, n + 1 - 1 + n17, n, intW2);
                }
                lstres = zero;
                i = 1;
                while (i <= n) {
                    lstres = Math.max(lstres, Math.abs(dArray9[i - 1 + (j - 1) * n14 + n13]));
                    ++i;
                }
                if (lstres != zero) {
                    dArray10[Dgtrfs.j - 1 + n15] = dArray10[j - 1 + n15] / lstres;
                }
                ++j;
            }
        }
    }

    private static void dlacon_adapter(int n, double[] dArray, int n2, double[] dArray2, int n3, int[] nArray, int n4, double[] dArray3, int n5, intW intW2) {
        doubleW doubleW2 = new doubleW(dArray3[n5]);
        Dlacon.dlacon(n, dArray, n2, dArray2, n3, nArray, n4, doubleW2, intW2);
        dArray3[n5] = doubleW2.val;
    }

    static {
        one = 1.0;
        two = 2.0;
        three = 3.0;
        transn = new String(" ");
        transt = new String(" ");
        kase = new intW(0);
    }
}

