/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dcopy;
import org.netlib.blas.Drot;
import org.netlib.lapack.Dlabad;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlanhs;
import org.netlib.lapack.Dlanv2;
import org.netlib.lapack.Dlarfg;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Dlahqr {
    static double zero;
    static double one;
    static double dat1;
    static double dat2;
    static int i;
    static int i1;
    static int i2;
    static int itn;
    static int its;
    static int j;
    static int k;
    static int l;
    static int m;
    static int nh;
    static int nr;
    static int nz;
    static doubleW cs;
    static double h00;
    static double h10;
    static double h11;
    static double h12;
    static double h21;
    static double h22;
    static double h33;
    static double h33s;
    static double h43h34;
    static double h44;
    static double h44s;
    static doubleW ovfl;
    static double s;
    static double smlnum;
    static doubleW sn;
    static double sum;
    static doubleW t1;
    static double t2;
    static double t3;
    static double tst1;
    static double ulp;
    static doubleW unfl;
    static double v1;
    static double v2;
    static double v3;
    static double[] v;
    static double[] work;

    public static void dlahqr(boolean bl, boolean bl2, int n, int n2, int n3, double[] dArray, int n4, int n5, double[] dArray2, int n6, double[] dArray3, int n7, int n8, int n9, double[] dArray4, int n10, int n11, intW intW2) {
        intW2.val = 0;
        if (n == 0) {
        } else if (n2 == n3) {
            dArray2[n2 - 1 + n6] = dArray[n2 - 1 + (n2 - 1) * n5 + n4];
            dArray3[n2 - 1 + n7] = zero;
        } else {
            nh = n3 - n2 + 1;
            nz = n9 - n8 + 1;
            Dlahqr.unfl.val = Dlamch.dlamch("Safe minimum");
            Dlahqr.ovfl.val = one / Dlahqr.unfl.val;
            Dlabad.dlabad(unfl, ovfl);
            ulp = Dlamch.dlamch("Precision");
            smlnum = Dlahqr.unfl.val * ((double)nh / ulp);
            if (bl) {
                i1 = 1;
                i2 = n;
            }
            itn = 30 * nh;
            i = n3;
            while (true) {
                block41: {
                    l = n2;
                    if (i < n2) {
                        break;
                    }
                    its = 0;
                    while (its <= itn) {
                        int n12 = -1;
                        k = i;
                        while (k >= l + 1) {
                            tst1 = Math.abs(dArray[k - 1 - 1 + (k - 1 - 1) * n5 + n4]) + Math.abs(dArray[k - 1 + (k - 1) * n5 + n4]);
                            if (tst1 == zero) {
                                tst1 = Dlanhs.dlanhs("1", i - l + 1, dArray, l - 1 + (l - 1) * n5 + n4, n5, work, 0);
                            }
                            if (Math.abs(dArray[k - 1 + (k - 1 - 1) * n5 + n4]) <= Math.max(ulp * tst1, smlnum)) {
                                break;
                            }
                            k += n12;
                        }
                        if ((l = k) > n2) {
                            dArray[Dlahqr.l - 1 + (Dlahqr.l - 1 - 1) * n5 + n4] = zero;
                        }
                        if (l >= i - 1) break block41;
                        if (!bl) {
                            i1 = l;
                            i2 = i;
                        }
                        if (its == 10 || its == 20) {
                            s = Math.abs(dArray[i - 1 + (i - 1 - 1) * n5 + n4]) + Math.abs(dArray[i - 1 - 1 + (i - 2 - 1) * n5 + n4]);
                            h33 = h44 = dat1 * s;
                            h43h34 = dat2 * s * s;
                        } else {
                            h44 = dArray[i - 1 + (i - 1) * n5 + n4];
                            h33 = dArray[i - 1 - 1 + (i - 1 - 1) * n5 + n4];
                            h43h34 = dArray[i - 1 + (i - 1 - 1) * n5 + n4] * dArray[i - 1 - 1 + (i - 1) * n5 + n4];
                        }
                        int n13 = -1;
                        m = i - 2;
                        while (m >= l) {
                            h11 = dArray[m - 1 + (m - 1) * n5 + n4];
                            h22 = dArray[m + 1 - 1 + (m + 1 - 1) * n5 + n4];
                            h21 = dArray[m + 1 - 1 + (m - 1) * n5 + n4];
                            h12 = dArray[m - 1 + (m + 1 - 1) * n5 + n4];
                            h44s = h44 - h11;
                            h33s = h33 - h11;
                            v1 = (h33s * h44s - h43h34) / h21 + h12;
                            v2 = h22 - h11 - h33s - h44s;
                            v3 = dArray[m + 2 - 1 + (m + 1 - 1) * n5 + n4];
                            s = Math.abs(v1) + Math.abs(v2) + Math.abs(v3);
                            Dlahqr.v[0] = v1 /= s;
                            Dlahqr.v[1] = v2 /= s;
                            Dlahqr.v[2] = v3 /= s;
                            if (m == l) {
                                break;
                            }
                            h00 = dArray[m - 1 - 1 + (m - 1 - 1) * n5 + n4];
                            h10 = dArray[m - 1 + (m - 1 - 1) * n5 + n4];
                            tst1 = Math.abs(v1) * (Math.abs(h00) + Math.abs(h11) + Math.abs(h22));
                            if (Math.abs(h10) * (Math.abs(v2) + Math.abs(v3)) <= ulp * tst1) {
                                break;
                            }
                            m += n13;
                        }
                        k = m;
                        while (k <= i - 1) {
                            nr = Math.min(3, i - k + 1);
                            if (k > m) {
                                Dcopy.dcopy(nr, dArray, k - 1 + (k - 1 - 1) * n5 + n4, 1, v, 0, 1);
                            }
                            Dlahqr.dlarfg_adapter(nr, v, 0, v, 1, 1, t1);
                            if (k > m) {
                                dArray[Dlahqr.k - 1 + (Dlahqr.k - 1 - 1) * n5 + n4] = v[0];
                                dArray[Dlahqr.k + 1 - 1 + (Dlahqr.k - 1 - 1) * n5 + n4] = zero;
                                if (k < i - 1) {
                                    dArray[Dlahqr.k + 2 - 1 + (Dlahqr.k - 1 - 1) * n5 + n4] = zero;
                                }
                            } else if (m > l) {
                                dArray[Dlahqr.k - 1 + (Dlahqr.k - 1 - 1) * n5 + n4] = -dArray[k - 1 + (k - 1 - 1) * n5 + n4];
                            }
                            v2 = v[1];
                            t2 = Dlahqr.t1.val * v2;
                            if (nr == 3) {
                                v3 = v[2];
                                t3 = Dlahqr.t1.val * v3;
                                j = k;
                                while (j <= i2) {
                                    sum = dArray[k - 1 + (j - 1) * n5 + n4] + v2 * dArray[k + 1 - 1 + (j - 1) * n5 + n4] + v3 * dArray[k + 2 - 1 + (j - 1) * n5 + n4];
                                    dArray[Dlahqr.k - 1 + (Dlahqr.j - 1) * n5 + n4] = dArray[k - 1 + (j - 1) * n5 + n4] - sum * Dlahqr.t1.val;
                                    dArray[Dlahqr.k + 1 - 1 + (Dlahqr.j - 1) * n5 + n4] = dArray[k + 1 - 1 + (j - 1) * n5 + n4] - sum * t2;
                                    dArray[Dlahqr.k + 2 - 1 + (Dlahqr.j - 1) * n5 + n4] = dArray[k + 2 - 1 + (j - 1) * n5 + n4] - sum * t3;
                                    ++j;
                                }
                                j = i1;
                                while (j <= Math.min(k + 3, i)) {
                                    sum = dArray[j - 1 + (k - 1) * n5 + n4] + v2 * dArray[j - 1 + (k + 1 - 1) * n5 + n4] + v3 * dArray[j - 1 + (k + 2 - 1) * n5 + n4];
                                    dArray[Dlahqr.j - 1 + (Dlahqr.k - 1) * n5 + n4] = dArray[j - 1 + (k - 1) * n5 + n4] - sum * Dlahqr.t1.val;
                                    dArray[Dlahqr.j - 1 + (Dlahqr.k + 1 - 1) * n5 + n4] = dArray[j - 1 + (k + 1 - 1) * n5 + n4] - sum * t2;
                                    dArray[Dlahqr.j - 1 + (Dlahqr.k + 2 - 1) * n5 + n4] = dArray[j - 1 + (k + 2 - 1) * n5 + n4] - sum * t3;
                                    ++j;
                                }
                                if (bl2) {
                                    j = n8;
                                    while (j <= n9) {
                                        sum = dArray4[j - 1 + (k - 1) * n11 + n10] + v2 * dArray4[j - 1 + (k + 1 - 1) * n11 + n10] + v3 * dArray4[j - 1 + (k + 2 - 1) * n11 + n10];
                                        dArray4[Dlahqr.j - 1 + (Dlahqr.k - 1) * n11 + n10] = dArray4[j - 1 + (k - 1) * n11 + n10] - sum * Dlahqr.t1.val;
                                        dArray4[Dlahqr.j - 1 + (Dlahqr.k + 1 - 1) * n11 + n10] = dArray4[j - 1 + (k + 1 - 1) * n11 + n10] - sum * t2;
                                        dArray4[Dlahqr.j - 1 + (Dlahqr.k + 2 - 1) * n11 + n10] = dArray4[j - 1 + (k + 2 - 1) * n11 + n10] - sum * t3;
                                        ++j;
                                    }
                                }
                            } else if (nr == 2) {
                                j = k;
                                while (j <= i2) {
                                    sum = dArray[k - 1 + (j - 1) * n5 + n4] + v2 * dArray[k + 1 - 1 + (j - 1) * n5 + n4];
                                    dArray[Dlahqr.k - 1 + (Dlahqr.j - 1) * n5 + n4] = dArray[k - 1 + (j - 1) * n5 + n4] - sum * Dlahqr.t1.val;
                                    dArray[Dlahqr.k + 1 - 1 + (Dlahqr.j - 1) * n5 + n4] = dArray[k + 1 - 1 + (j - 1) * n5 + n4] - sum * t2;
                                    ++j;
                                }
                                j = i1;
                                while (j <= i) {
                                    sum = dArray[j - 1 + (k - 1) * n5 + n4] + v2 * dArray[j - 1 + (k + 1 - 1) * n5 + n4];
                                    dArray[Dlahqr.j - 1 + (Dlahqr.k - 1) * n5 + n4] = dArray[j - 1 + (k - 1) * n5 + n4] - sum * Dlahqr.t1.val;
                                    dArray[Dlahqr.j - 1 + (Dlahqr.k + 1 - 1) * n5 + n4] = dArray[j - 1 + (k + 1 - 1) * n5 + n4] - sum * t2;
                                    ++j;
                                }
                                if (bl2) {
                                    j = n8;
                                    while (j <= n9) {
                                        sum = dArray4[j - 1 + (k - 1) * n11 + n10] + v2 * dArray4[j - 1 + (k + 1 - 1) * n11 + n10];
                                        dArray4[Dlahqr.j - 1 + (Dlahqr.k - 1) * n11 + n10] = dArray4[j - 1 + (k - 1) * n11 + n10] - sum * Dlahqr.t1.val;
                                        dArray4[Dlahqr.j - 1 + (Dlahqr.k + 1 - 1) * n11 + n10] = dArray4[j - 1 + (k + 1 - 1) * n11 + n10] - sum * t2;
                                        ++j;
                                    }
                                }
                            }
                            ++k;
                        }
                        ++its;
                    }
                    intW2.val = i;
                    break;
                }
                if (l == i) {
                    dArray2[Dlahqr.i - 1 + n6] = dArray[i - 1 + (i - 1) * n5 + n4];
                    dArray3[Dlahqr.i - 1 + n7] = zero;
                } else if (l == i - 1) {
                    Dlahqr.dlanv2_adapter(dArray, i - 1 - 1 + (i - 1 - 1) * n5 + n4, dArray, i - 1 - 1 + (i - 1) * n5 + n4, dArray, i - 1 + (i - 1 - 1) * n5 + n4, dArray, i - 1 + (i - 1) * n5 + n4, dArray2, i - 1 - 1 + n6, dArray3, i - 1 - 1 + n7, dArray2, i - 1 + n6, dArray3, i - 1 + n7, cs, sn);
                    if (bl) {
                        if (i2 > i) {
                            Drot.drot(i2 - i, dArray, i - 1 - 1 + (i + 1 - 1) * n5 + n4, n5, dArray, i - 1 + (i + 1 - 1) * n5 + n4, n5, Dlahqr.cs.val, Dlahqr.sn.val);
                        }
                        Drot.drot(i - i1 - 1, dArray, i1 - 1 + (i - 1 - 1) * n5 + n4, 1, dArray, i1 - 1 + (i - 1) * n5 + n4, 1, Dlahqr.cs.val, Dlahqr.sn.val);
                    }
                    if (bl2) {
                        Drot.drot(nz, dArray4, n8 - 1 + (i - 1 - 1) * n11 + n10, 1, dArray4, n8 - 1 + (i - 1) * n11 + n10, 1, Dlahqr.cs.val, Dlahqr.sn.val);
                    }
                }
                itn -= its;
                i = l - 1;
            }
        }
    }

    private static void dlarfg_adapter(int n, double[] dArray, int n2, double[] dArray2, int n3, int n4, doubleW doubleW2) {
        doubleW doubleW3 = new doubleW(dArray[n2]);
        Dlarfg.dlarfg(n, doubleW3, dArray2, n3, n4, doubleW2);
        dArray[n2] = doubleW3.val;
    }

    private static void dlanv2_adapter(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3, double[] dArray4, int n4, double[] dArray5, int n5, double[] dArray6, int n6, double[] dArray7, int n7, double[] dArray8, int n8, doubleW doubleW2, doubleW doubleW3) {
        doubleW doubleW4 = new doubleW(dArray[n]);
        doubleW doubleW5 = new doubleW(dArray2[n2]);
        doubleW doubleW6 = new doubleW(dArray3[n3]);
        doubleW doubleW7 = new doubleW(dArray4[n4]);
        doubleW doubleW8 = new doubleW(dArray5[n5]);
        doubleW doubleW9 = new doubleW(dArray6[n6]);
        doubleW doubleW10 = new doubleW(dArray7[n7]);
        doubleW doubleW11 = new doubleW(dArray8[n8]);
        Dlanv2.dlanv2(doubleW4, doubleW5, doubleW6, doubleW7, doubleW8, doubleW9, doubleW10, doubleW11, doubleW2, doubleW3);
        dArray[n] = doubleW4.val;
        dArray2[n2] = doubleW5.val;
        dArray3[n3] = doubleW6.val;
        dArray4[n4] = doubleW7.val;
        dArray5[n5] = doubleW8.val;
        dArray6[n6] = doubleW9.val;
        dArray7[n7] = doubleW10.val;
        dArray8[n8] = doubleW11.val;
    }

    static {
        one = 1.0;
        dat1 = 0.75;
        dat2 = -0.4375;
        cs = new doubleW(0.0);
        ovfl = new doubleW(0.0);
        sn = new doubleW(0.0);
        t1 = new doubleW(0.0);
        unfl = new doubleW(0.0);
        v = new double[3];
        work = new double[1];
    }
}

