/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.lapack.Dlamch;
import org.netlib.util.StringW;

public class Dlaqsb {
    static double one = 1.0;
    static double thresh = 0.1;
    static int i;
    static int j;
    static double cj;
    static double large;
    static double small;

    public static void dlaqsb(String string, int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, double d, double d2, StringW stringW) {
        if (n <= 0) {
            stringW.val = "N";
        } else {
            small = Dlamch.dlamch("Safe minimum") / Dlamch.dlamch("Precision");
            large = one / small;
            if (d >= thresh && d2 >= small && d2 <= large) {
                stringW.val = "N";
            } else {
                if (string.toLowerCase().charAt(0) == "U".toLowerCase().charAt(0)) {
                    j = 1;
                    while (j <= n) {
                        cj = dArray2[j - 1 + n5];
                        i = Math.max(1, j - n2);
                        while (i <= j) {
                            dArray[n2 + 1 + Dlaqsb.i - Dlaqsb.j - 1 + (Dlaqsb.j - 1) * n4 + n3] = cj * dArray2[i - 1 + n5] * dArray[n2 + 1 + i - j - 1 + (j - 1) * n4 + n3];
                            ++i;
                        }
                        ++j;
                    }
                } else {
                    j = 1;
                    while (j <= n) {
                        cj = dArray2[j - 1 + n5];
                        i = j;
                        while (i <= Math.min(n, j + n2)) {
                            dArray[1 + Dlaqsb.i - Dlaqsb.j - 1 + (Dlaqsb.j - 1) * n4 + n3] = cj * dArray2[i - 1 + n5] * dArray[1 + i - j - 1 + (j - 1) * n4 + n3];
                            ++i;
                        }
                        ++j;
                    }
                }
                stringW.val = "Y";
            }
        }
    }
}

