/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dasum;
import org.netlib.blas.Daxpy;
import org.netlib.blas.Ddot;
import org.netlib.blas.Dscal;
import org.netlib.blas.Idamax;
import org.netlib.lapack.Dladiv;
import org.netlib.lapack.Dlaln2;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlange;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Dlaqtr {
    static double zero;
    static double one;
    static boolean notran;
    static int i;
    static intW ierr;
    static int j;
    static int j1;
    static int j2;
    static int jnext;
    static int k;
    static int n1;
    static int n2;
    static double bignum;
    static double eps;
    static double rec;
    static doubleW scaloc;
    static doubleW si;
    static double smin;
    static double sminw;
    static double smlnum;
    static doubleW sr;
    static double tjj;
    static double tmp;
    static double xj;
    static double xmax;
    static doubleW xnorm;
    static double z;
    static double[] d;
    static double[] v;

    public static void dlaqtr(boolean bl, boolean bl2, int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, double d, doubleW doubleW2, double[] dArray3, int n5, double[] dArray4, int n6, intW intW2) {
        notran = !bl;
        intW2.val = 0;
        if (n == 0) {
        } else {
            eps = Dlamch.dlamch("P");
            smlnum = Dlamch.dlamch("S") / eps;
            bignum = one / smlnum;
            Dlaqtr.xnorm.val = Dlange.dlange("M", n, n, dArray, n2, n3, Dlaqtr.d, 0);
            if (!bl2) {
                Dlaqtr.xnorm.val = Math.max(Dlaqtr.xnorm.val > Math.abs(d) ? Dlaqtr.xnorm.val : Math.abs(d), Dlange.dlange("M", n, 1, dArray2, n4, n, Dlaqtr.d, 0));
            }
            smin = Math.max(smlnum, eps * Dlaqtr.xnorm.val);
            dArray4[n6] = zero;
            j = 2;
            while (j <= n) {
                dArray4[Dlaqtr.j - 1 + n6] = Dasum.dasum(j - 1, dArray, (j - 1) * n3 + n2, 1);
                ++j;
            }
            if (!bl2) {
                i = 2;
                while (i <= n) {
                    dArray4[Dlaqtr.i - 1 + n6] = dArray4[i - 1 + n6] + Math.abs(dArray2[i - 1 + n4]);
                    ++i;
                }
            }
            Dlaqtr.n2 = 2 * n;
            n1 = n;
            if (!bl2) {
                n1 = Dlaqtr.n2;
            }
            k = Idamax.idamax(n1, dArray3, n5, 1);
            xmax = Math.abs(dArray3[k - 1 + n5]);
            doubleW2.val = one;
            if (xmax > bignum) {
                doubleW2.val = bignum / xmax;
                Dscal.dscal(n1, doubleW2.val, dArray3, n5, 1);
                xmax = bignum;
            }
            if (bl2) {
                if (notran) {
                    jnext = n;
                    int n7 = -1;
                    j = n;
                    while (j >= 1) {
                        if (j <= jnext) {
                            j1 = j;
                            j2 = j;
                            jnext = j - 1;
                            if (j > 1 && dArray[j - 1 + (j - 1 - 1) * n3 + n2] != zero) {
                                j1 = j - 1;
                                j2 = j;
                                jnext = j - 2;
                            }
                            if (j1 == j2) {
                                xj = Math.abs(dArray3[j1 - 1 + n5]);
                                tjj = Math.abs(dArray[j1 - 1 + (j1 - 1) * n3 + n2]);
                                tmp = dArray[j1 - 1 + (j1 - 1) * n3 + n2];
                                if (tjj < smin) {
                                    tmp = smin;
                                    tjj = smin;
                                    intW2.val = 1;
                                }
                                if (xj != zero) {
                                    if (tjj < one && xj > bignum * tjj) {
                                        rec = one / xj;
                                        Dscal.dscal(n, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                        xmax *= rec;
                                    }
                                    dArray3[Dlaqtr.j1 - 1 + n5] = dArray3[j1 - 1 + n5] / tmp;
                                    xj = Math.abs(dArray3[j1 - 1 + n5]);
                                    if (xj > one && dArray4[j1 - 1 + n6] > (bignum - xmax) * (rec = one / xj)) {
                                        Dscal.dscal(n, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                    }
                                    if (j1 > 1) {
                                        Daxpy.daxpy(j1 - 1, -dArray3[j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                        k = Idamax.idamax(j1 - 1, dArray3, n5, 1);
                                        xmax = Math.abs(dArray3[k - 1 + n5]);
                                    }
                                }
                            } else {
                                Dlaqtr.d[0] = dArray3[j1 - 1 + n5];
                                Dlaqtr.d[1] = dArray3[j2 - 1 + n5];
                                Dlaln2.dlaln2(false, 2, 1, smin, one, dArray, j1 - 1 + (j1 - 1) * n3 + n2, n3, one, one, Dlaqtr.d, 0, 2, zero, zero, v, 0, 2, scaloc, xnorm, ierr);
                                if (Dlaqtr.ierr.val != 0) {
                                    intW2.val = 2;
                                }
                                if (Dlaqtr.scaloc.val != one) {
                                    Dscal.dscal(n, Dlaqtr.scaloc.val, dArray3, n5, 1);
                                    doubleW2.val *= Dlaqtr.scaloc.val;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = v[0];
                                dArray3[Dlaqtr.j2 - 1 + n5] = v[1];
                                xj = Math.max(Math.abs(v[0]), Math.abs(v[1]));
                                if (xj > one) {
                                    rec = one / xj;
                                    if (Math.max(dArray4[j1 - 1 + n6], dArray4[j2 - 1 + n6]) > (bignum - xmax) * rec) {
                                        Dscal.dscal(n, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                    }
                                }
                                if (j1 > 1) {
                                    Daxpy.daxpy(j1 - 1, -dArray3[j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                    Daxpy.daxpy(j1 - 1, -dArray3[j2 - 1 + n5], dArray, (j2 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                    k = Idamax.idamax(j1 - 1, dArray3, n5, 1);
                                    xmax = Math.abs(dArray3[k - 1 + n5]);
                                }
                            }
                        }
                        j += n7;
                    }
                } else {
                    jnext = 1;
                    j = 1;
                    while (j <= n) {
                        if (j >= jnext) {
                            j1 = j;
                            j2 = j;
                            jnext = j + 1;
                            if (j < n && dArray[j + 1 - 1 + (j - 1) * n3 + n2] != zero) {
                                j1 = j;
                                j2 = j + 1;
                                jnext = j + 2;
                            }
                            if (j1 == j2) {
                                xj = Math.abs(dArray3[j1 - 1 + n5]);
                                if (xmax > one && dArray4[j1 - 1 + n6] > (bignum - xj) * (rec = one / xmax)) {
                                    Dscal.dscal(n, rec, dArray3, n5, 1);
                                    doubleW2.val *= rec;
                                    xmax *= rec;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = dArray3[j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                xj = Math.abs(dArray3[j1 - 1 + n5]);
                                tjj = Math.abs(dArray[j1 - 1 + (j1 - 1) * n3 + n2]);
                                tmp = dArray[j1 - 1 + (j1 - 1) * n3 + n2];
                                if (tjj < smin) {
                                    tmp = smin;
                                    tjj = smin;
                                    intW2.val = 1;
                                }
                                if (tjj < one && xj > bignum * tjj) {
                                    rec = one / xj;
                                    Dscal.dscal(n, rec, dArray3, n5, 1);
                                    doubleW2.val *= rec;
                                    xmax *= rec;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = dArray3[j1 - 1 + n5] / tmp;
                                xmax = Math.max(xmax, Math.abs(dArray3[j1 - 1 + n5]));
                            } else {
                                xj = Math.max(Math.abs(dArray3[j1 - 1 + n5]), Math.abs(dArray3[j2 - 1 + n5]));
                                if (xmax > one) {
                                    rec = one / xmax;
                                    if (Math.max(dArray4[j2 - 1 + n6], dArray4[j1 - 1 + n6]) > (bignum - xj) * rec) {
                                        Dscal.dscal(n, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                        xmax *= rec;
                                    }
                                }
                                Dlaqtr.d[0] = dArray3[j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                Dlaqtr.d[1] = dArray3[j2 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j2 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                Dlaln2.dlaln2(true, 2, 1, smin, one, dArray, j1 - 1 + (j1 - 1) * n3 + n2, n3, one, one, Dlaqtr.d, 0, 2, zero, zero, v, 0, 2, scaloc, xnorm, ierr);
                                if (Dlaqtr.ierr.val != 0) {
                                    intW2.val = 2;
                                }
                                if (Dlaqtr.scaloc.val != one) {
                                    Dscal.dscal(n, Dlaqtr.scaloc.val, dArray3, n5, 1);
                                    doubleW2.val *= Dlaqtr.scaloc.val;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = v[0];
                                dArray3[Dlaqtr.j2 - 1 + n5] = v[1];
                                xmax = Math.max(Math.abs(dArray3[j1 - 1 + n5]) > Math.abs(dArray3[j2 - 1 + n5]) ? Math.abs(dArray3[j1 - 1 + n5]) : Math.abs(dArray3[j2 - 1 + n5]), xmax);
                            }
                        }
                        ++j;
                    }
                }
            } else {
                sminw = Math.max(eps * Math.abs(d), smin);
                if (notran) {
                    jnext = n;
                    int n8 = -1;
                    j = n;
                    while (j >= 1) {
                        if (j <= jnext) {
                            j1 = j;
                            j2 = j;
                            jnext = j - 1;
                            if (j > 1 && dArray[j - 1 + (j - 1 - 1) * n3 + n2] != zero) {
                                j1 = j - 1;
                                j2 = j;
                                jnext = j - 2;
                            }
                            if (j1 == j2) {
                                z = d;
                                if (j1 == 1) {
                                    z = dArray2[n4];
                                }
                                xj = Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[n + j1 - 1 + n5]);
                                tjj = Math.abs(dArray[j1 - 1 + (j1 - 1) * n3 + n2]) + Math.abs(z);
                                tmp = dArray[j1 - 1 + (j1 - 1) * n3 + n2];
                                if (tjj < sminw) {
                                    tmp = sminw;
                                    tjj = sminw;
                                    intW2.val = 1;
                                }
                                if (xj != zero) {
                                    if (tjj < one && xj > bignum * tjj) {
                                        rec = one / xj;
                                        Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                        xmax *= rec;
                                    }
                                    Dladiv.dladiv(dArray3[j1 - 1 + n5], dArray3[n + j1 - 1 + n5], tmp, z, sr, si);
                                    dArray3[Dlaqtr.j1 - 1 + n5] = Dlaqtr.sr.val;
                                    dArray3[n + Dlaqtr.j1 - 1 + n5] = Dlaqtr.si.val;
                                    xj = Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[n + j1 - 1 + n5]);
                                    if (xj > one && dArray4[j1 - 1 + n6] > (bignum - xmax) * (rec = one / xj)) {
                                        Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                    }
                                    if (j1 > 1) {
                                        Daxpy.daxpy(j1 - 1, -dArray3[j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                        Daxpy.daxpy(j1 - 1, -dArray3[n + j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                        dArray3[n5] = dArray3[n5] + dArray2[j1 - 1 + n4] * dArray3[n + j1 - 1 + n5];
                                        dArray3[n + 1 - 1 + n5] = dArray3[n + 1 - 1 + n5] - dArray2[j1 - 1 + n4] * dArray3[j1 - 1 + n5];
                                        xmax = zero;
                                        k = 1;
                                        while (k <= j1 - 1) {
                                            xmax = Math.max(xmax, Math.abs(dArray3[k - 1 + n5]) + Math.abs(dArray3[k + n - 1 + n5]));
                                            ++k;
                                        }
                                    }
                                }
                            } else {
                                Dlaqtr.d[0] = dArray3[j1 - 1 + n5];
                                Dlaqtr.d[1] = dArray3[j2 - 1 + n5];
                                Dlaqtr.d[2] = dArray3[n + j1 - 1 + n5];
                                Dlaqtr.d[3] = dArray3[n + j2 - 1 + n5];
                                Dlaln2.dlaln2(false, 2, 2, sminw, one, dArray, j1 - 1 + (j1 - 1) * n3 + n2, n3, one, one, Dlaqtr.d, 0, 2, zero, -d, v, 0, 2, scaloc, xnorm, ierr);
                                if (Dlaqtr.ierr.val != 0) {
                                    intW2.val = 2;
                                }
                                if (Dlaqtr.scaloc.val != one) {
                                    Dscal.dscal(2 * n, Dlaqtr.scaloc.val, dArray3, n5, 1);
                                    doubleW2.val = Dlaqtr.scaloc.val * doubleW2.val;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = v[0];
                                dArray3[Dlaqtr.j2 - 1 + n5] = v[1];
                                dArray3[n + Dlaqtr.j1 - 1 + n5] = v[2];
                                dArray3[n + Dlaqtr.j2 - 1 + n5] = v[3];
                                xj = Math.max(Math.abs(v[0]) + Math.abs(v[2]), Math.abs(v[1]) + Math.abs(v[3]));
                                if (xj > one) {
                                    rec = one / xj;
                                    if (Math.max(dArray4[j1 - 1 + n6], dArray4[j2 - 1 + n6]) > (bignum - xmax) * rec) {
                                        Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                    }
                                }
                                if (j1 > 1) {
                                    Daxpy.daxpy(j1 - 1, -dArray3[j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                    Daxpy.daxpy(j1 - 1, -dArray3[j2 - 1 + n5], dArray, (j2 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                    Daxpy.daxpy(j1 - 1, -dArray3[n + j1 - 1 + n5], dArray, (j1 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                    Daxpy.daxpy(j1 - 1, -dArray3[n + j2 - 1 + n5], dArray, (j2 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                    dArray3[n5] = dArray3[n5] + dArray2[j1 - 1 + n4] * dArray3[n + j1 - 1 + n5] + dArray2[j2 - 1 + n4] * dArray3[n + j2 - 1 + n5];
                                    dArray3[n + 1 - 1 + n5] = dArray3[n + 1 - 1 + n5] - dArray2[j1 - 1 + n4] * dArray3[j1 - 1 + n5] - dArray2[j2 - 1 + n4] * dArray3[j2 - 1 + n5];
                                    xmax = zero;
                                    k = 1;
                                    while (k <= j1 - 1) {
                                        xmax = Math.max(Math.abs(dArray3[k - 1 + n5]) + Math.abs(dArray3[k + n - 1 + n5]), xmax);
                                        ++k;
                                    }
                                }
                            }
                        }
                        j += n8;
                    }
                } else {
                    jnext = 1;
                    j = 1;
                    while (j <= n) {
                        if (j >= jnext) {
                            j1 = j;
                            j2 = j;
                            jnext = j + 1;
                            if (j < n && dArray[j + 1 - 1 + (j - 1) * n3 + n2] != zero) {
                                j1 = j;
                                j2 = j + 1;
                                jnext = j + 2;
                            }
                            if (j1 == j2) {
                                xj = Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[j1 + n - 1 + n5]);
                                if (xmax > one && dArray4[j1 - 1 + n6] > (bignum - xj) * (rec = one / xmax)) {
                                    Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                    doubleW2.val *= rec;
                                    xmax *= rec;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = dArray3[j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                dArray3[n + Dlaqtr.j1 - 1 + n5] = dArray3[n + j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                if (j1 > 1) {
                                    dArray3[Dlaqtr.j1 - 1 + n5] = dArray3[j1 - 1 + n5] - dArray2[j1 - 1 + n4] * dArray3[n + 1 - 1 + n5];
                                    dArray3[n + Dlaqtr.j1 - 1 + n5] = dArray3[n + j1 - 1 + n5] + dArray2[j1 - 1 + n4] * dArray3[n5];
                                }
                                xj = Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[j1 + n - 1 + n5]);
                                z = d;
                                if (j1 == 1) {
                                    z = dArray2[n4];
                                }
                                tjj = Math.abs(dArray[j1 - 1 + (j1 - 1) * n3 + n2]) + Math.abs(z);
                                tmp = dArray[j1 - 1 + (j1 - 1) * n3 + n2];
                                if (tjj < sminw) {
                                    tmp = sminw;
                                    tjj = sminw;
                                    intW2.val = 1;
                                }
                                if (tjj < one && xj > bignum * tjj) {
                                    rec = one / xj;
                                    Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                    doubleW2.val *= rec;
                                    xmax *= rec;
                                }
                                Dladiv.dladiv(dArray3[j1 - 1 + n5], dArray3[n + j1 - 1 + n5], tmp, -z, sr, si);
                                dArray3[Dlaqtr.j1 - 1 + n5] = Dlaqtr.sr.val;
                                dArray3[Dlaqtr.j1 + n - 1 + n5] = Dlaqtr.si.val;
                                xmax = Math.max(Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[j1 + n - 1 + n5]), xmax);
                            } else {
                                xj = Math.max(Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[n + j1 - 1 + n5]), Math.abs(dArray3[j2 - 1 + n5]) + Math.abs(dArray3[n + j2 - 1 + n5]));
                                if (xmax > one) {
                                    rec = one / xmax;
                                    if (Math.max(dArray4[j1 - 1 + n6], dArray4[j2 - 1 + n6]) > (bignum - xj) / xmax) {
                                        Dscal.dscal(Dlaqtr.n2, rec, dArray3, n5, 1);
                                        doubleW2.val *= rec;
                                        xmax *= rec;
                                    }
                                }
                                Dlaqtr.d[0] = dArray3[j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                Dlaqtr.d[1] = dArray3[j2 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j2 - 1) * n3 + n2, 1, dArray3, n5, 1);
                                Dlaqtr.d[2] = dArray3[n + j1 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j1 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                Dlaqtr.d[3] = dArray3[n + j2 - 1 + n5] - Ddot.ddot(j1 - 1, dArray, (j2 - 1) * n3 + n2, 1, dArray3, n + 1 - 1 + n5, 1);
                                Dlaqtr.d[0] = Dlaqtr.d[0] - dArray2[j1 - 1 + n4] * dArray3[n + 1 - 1 + n5];
                                Dlaqtr.d[1] = Dlaqtr.d[1] - dArray2[j2 - 1 + n4] * dArray3[n + 1 - 1 + n5];
                                Dlaqtr.d[2] = Dlaqtr.d[2] + dArray2[j1 - 1 + n4] * dArray3[n5];
                                Dlaqtr.d[3] = Dlaqtr.d[3] + dArray2[j2 - 1 + n4] * dArray3[n5];
                                Dlaln2.dlaln2(true, 2, 2, sminw, one, dArray, j1 - 1 + (j1 - 1) * n3 + n2, n3, one, one, Dlaqtr.d, 0, 2, zero, d, v, 0, 2, scaloc, xnorm, ierr);
                                if (Dlaqtr.ierr.val != 0) {
                                    intW2.val = 2;
                                }
                                if (Dlaqtr.scaloc.val != one) {
                                    Dscal.dscal(Dlaqtr.n2, Dlaqtr.scaloc.val, dArray3, n5, 1);
                                    doubleW2.val = Dlaqtr.scaloc.val * doubleW2.val;
                                }
                                dArray3[Dlaqtr.j1 - 1 + n5] = v[0];
                                dArray3[Dlaqtr.j2 - 1 + n5] = v[1];
                                dArray3[n + Dlaqtr.j1 - 1 + n5] = v[2];
                                dArray3[n + Dlaqtr.j2 - 1 + n5] = v[3];
                                xmax = Math.max(Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[n + j1 - 1 + n5]) > Math.abs(dArray3[j2 - 1 + n5]) + Math.abs(dArray3[n + j2 - 1 + n5]) ? Math.abs(dArray3[j1 - 1 + n5]) + Math.abs(dArray3[n + j1 - 1 + n5]) : Math.abs(dArray3[j2 - 1 + n5]) + Math.abs(dArray3[n + j2 - 1 + n5]), xmax);
                            }
                        }
                        ++j;
                    }
                }
            }
        }
    }

    static {
        one = 1.0;
        ierr = new intW(0);
        scaloc = new doubleW(0.0);
        si = new doubleW(0.0);
        sr = new doubleW(0.0);
        xnorm = new doubleW(0.0);
        d = new double[4];
        v = new double[4];
    }
}

