/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dnrm2;
import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlapy2;
import org.netlib.util.doubleW;

public class Dlarfg {
    static double one = 1.0;
    static double zero;
    static int j;
    static int knt;
    static double beta;
    static double rsafmn;
    static double safmin;
    static double xnorm;

    public static void dlarfg(int n, doubleW doubleW2, double[] dArray, int n2, int n3, doubleW doubleW3) {
        if (n <= 1) {
            doubleW3.val = zero;
        } else {
            xnorm = Dnrm2.dnrm2(n - 1, dArray, n2, n3);
            if (xnorm == zero) {
                doubleW3.val = zero;
            } else {
                beta = -(doubleW2.val >= 0.0 ? Math.abs(Dlapy2.dlapy2(doubleW2.val, xnorm)) : -Math.abs(Dlapy2.dlapy2(doubleW2.val, xnorm)));
                safmin = Dlamch.dlamch("S") / Dlamch.dlamch("E");
                if (Math.abs(beta) < safmin) {
                    rsafmn = one / safmin;
                    knt = 0;
                    while (true) {
                        ++knt;
                        Dscal.dscal(n - 1, rsafmn, dArray, n2, n3);
                        beta *= rsafmn;
                        doubleW2.val *= rsafmn;
                        if (!(Math.abs(beta) < safmin)) break;
                    }
                    xnorm = Dnrm2.dnrm2(n - 1, dArray, n2, n3);
                    beta = -(doubleW2.val >= 0.0 ? Math.abs(Dlapy2.dlapy2(doubleW2.val, xnorm)) : -Math.abs(Dlapy2.dlapy2(doubleW2.val, xnorm)));
                    doubleW3.val = (beta - doubleW2.val) / beta;
                    Dscal.dscal(n - 1, one / (doubleW2.val - beta), dArray, n2, n3);
                    doubleW2.val = beta;
                    j = 1;
                    while (j <= knt) {
                        doubleW2.val *= safmin;
                        ++j;
                    }
                } else {
                    doubleW3.val = (beta - doubleW2.val) / beta;
                    Dscal.dscal(n - 1, one / (doubleW2.val - beta), dArray, n2, n3);
                    doubleW2.val = beta;
                }
            }
        }
    }
}

