/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.lapack.Dlamch;
import org.netlib.util.doubleW;

public class Dlasv2 {
    static double zero;
    static double half;
    static double one;
    static double two;
    static double four;
    static boolean gasmal;
    static boolean swap;
    static int pmax;
    static double a;
    static double clt;
    static double crt;
    static double d;
    static double fa;
    static double ft;
    static double ga;
    static double gt;
    static double ha;
    static double ht;
    static double l;
    static double m;
    static double mm;
    static double r;
    static double s;
    static double slt;
    static double srt;
    static double t;
    static double temp;
    static double tsign;
    static double tt;

    public static void dlasv2(double d, double d2, double d3, doubleW doubleW2, doubleW doubleW3, doubleW doubleW4, doubleW doubleW5, doubleW doubleW6, doubleW doubleW7) {
        ft = d;
        fa = Math.abs(ft);
        ht = d3;
        ha = Math.abs(d3);
        pmax = 1;
        boolean bl = swap = ha > fa;
        if (swap) {
            pmax = 3;
            temp = ft;
            ft = ht;
            ht = temp;
            temp = fa;
            fa = ha;
            ha = temp;
        }
        if ((ga = Math.abs(gt = d2)) == zero) {
            doubleW2.val = ha;
            doubleW3.val = fa;
            clt = one;
            crt = one;
            slt = zero;
            srt = zero;
        } else {
            gasmal = true;
            if (ga > fa) {
                pmax = 2;
                if (fa / ga < Dlamch.dlamch("EPS")) {
                    gasmal = false;
                    doubleW3.val = ga;
                    doubleW2.val = ha > one ? fa / (ga / ha) : fa / ga * ha;
                    clt = one;
                    slt = ht / gt;
                    srt = one;
                    crt = ft / gt;
                }
            }
            if (gasmal) {
                Dlasv2.d = fa - ha;
                l = Dlasv2.d == fa ? one : Dlasv2.d / fa;
                m = gt / ft;
                t = two - l;
                mm = m * m;
                tt = t * t;
                s = Math.sqrt(tt + mm);
                r = l == zero ? Math.abs(m) : Math.sqrt(l * l + mm);
                a = half * (s + r);
                doubleW2.val = ha / a;
                doubleW3.val = fa * a;
                t = mm == zero ? (l == zero ? (ft >= 0.0 ? Math.abs(two) : -Math.abs(two)) * (gt >= 0.0 ? Math.abs(one) : -Math.abs(one)) : gt / (ft >= 0.0 ? Math.abs(Dlasv2.d) : -Math.abs(Dlasv2.d)) + m / t) : (m / (s + t) + m / (r + l)) * (one + a);
                l = Math.sqrt(t * t + four);
                crt = two / l;
                srt = t / l;
                clt = (crt + srt * m) / a;
                slt = ht / ft * srt / a;
            }
        }
        if (swap) {
            doubleW7.val = srt;
            doubleW6.val = crt;
            doubleW5.val = slt;
            doubleW4.val = clt;
        } else {
            doubleW7.val = clt;
            doubleW6.val = slt;
            doubleW5.val = crt;
            doubleW4.val = srt;
        }
        if (pmax == 1) {
            tsign = (doubleW5.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (doubleW7.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (d >= 0.0 ? Math.abs(one) : -Math.abs(one));
        }
        if (pmax == 2) {
            tsign = (doubleW4.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (doubleW7.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (d2 >= 0.0 ? Math.abs(one) : -Math.abs(one));
        }
        if (pmax == 3) {
            tsign = (doubleW4.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (doubleW6.val >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (d3 >= 0.0 ? Math.abs(one) : -Math.abs(one));
        }
        doubleW3.val = tsign >= 0.0 ? Math.abs(doubleW3.val) : -Math.abs(doubleW3.val);
        doubleW2.val = tsign * (d >= 0.0 ? Math.abs(one) : -Math.abs(one)) * (d3 >= 0.0 ? Math.abs(one) : -Math.abs(one)) >= 0.0 ? Math.abs(doubleW2.val) : -Math.abs(doubleW2.val);
    }

    static {
        half = 0.5;
        one = 1.0;
        two = 2.0;
        four = 4.0;
    }
}

