/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dgemm;
import org.netlib.blas.Dsyrk;
import org.netlib.blas.Dtrsm;
import org.netlib.lapack.Dpbtf2;
import org.netlib.lapack.Dpotf2;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dpbtrf {
    static double one = 1.0;
    static double zero;
    static int nbmax;
    static int ldwork;
    static int i;
    static int i2;
    static int i3;
    static int ib;
    static intW ii;
    static int j;
    static int jj;
    static int nb;
    static double[] work;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dpbtrf(String string, int n, int n2, double[] dArray, int n3, int n4, intW intW2) {
        intW2.val = 0;
        if (string.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0) && string.toLowerCase().charAt(0) != "L".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (n < 0) {
            intW2.val = -2;
        } else if (n2 < 0) {
            intW2.val = -3;
        } else if (n4 < n2 + 1) {
            intW2.val = -5;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DPBTRF", -intW2.val);
            return;
        }
        if (n == 0) {
            return;
        }
        nb = Ilaenv.ilaenv(1, "DPBTRF", string, n, n2, -1, -1);
        if ((nb = Math.min(nb, nbmax)) <= 1 || nb > n2) {
            Dpbtf2.dpbtf2(string, n, n2, dArray, n3, n4, intW2);
            return;
        }
        if (string.toLowerCase().charAt(0) == "U".toLowerCase().charAt(0)) {
            j = 1;
            while (j <= nb) {
                i = 1;
                while (i <= j - 1) {
                    Dpbtrf.work[Dpbtrf.i - 1 + (Dpbtrf.j - 1) * Dpbtrf.ldwork] = zero;
                    ++i;
                }
                ++j;
            }
            int n5 = nb;
            i = 1;
            while (!(n5 < 0 ? i < n : i > n)) {
                ib = Math.min(nb, n - i + 1);
                Dpotf2.dpotf2(string, ib, dArray, n2 + 1 - 1 + (i - 1) * n4 + n3, n4 - 1, ii);
                if (Dpbtrf.ii.val != 0) {
                    intW2.val = i + Dpbtrf.ii.val - 1;
                    return;
                }
                if (i + ib <= n) {
                    i2 = Math.min(n2 - ib, n - i - ib + 1);
                    i3 = Math.min(ib, n - i - n2 + 1);
                    if (i2 > 0) {
                        Dtrsm.dtrsm("Left", "Upper", "Transpose", "Non-unit", ib, i2, one, dArray, n2 + 1 - 1 + (i - 1) * n4 + n3, n4 - 1, dArray, n2 + 1 - ib - 1 + (i + ib - 1) * n4 + n3, n4 - 1);
                        Dsyrk.dsyrk("Upper", "Transpose", i2, ib, -one, dArray, n2 + 1 - ib - 1 + (i + ib - 1) * n4 + n3, n4 - 1, one, dArray, n2 + 1 - 1 + (i + ib - 1) * n4 + n3, n4 - 1);
                    }
                    if (i3 > 0) {
                        jj = 1;
                        while (jj <= i3) {
                            Dpbtrf.ii.val = jj;
                            while (Dpbtrf.ii.val <= ib) {
                                Dpbtrf.work[Dpbtrf.ii.val - 1 + (Dpbtrf.jj - 1) * Dpbtrf.ldwork] = dArray[Dpbtrf.ii.val - jj + 1 - 1 + (jj + i + n2 - 1 - 1) * n4 + n3];
                                ++Dpbtrf.ii.val;
                            }
                            ++jj;
                        }
                        Dtrsm.dtrsm("Left", "Upper", "Transpose", "Non-unit", ib, i3, one, dArray, n2 + 1 - 1 + (i - 1) * n4 + n3, n4 - 1, work, 0, ldwork);
                        if (i2 > 0) {
                            Dgemm.dgemm("Transpose", "No Transpose", i2, i3, ib, -one, dArray, n2 + 1 - ib - 1 + (i + ib - 1) * n4 + n3, n4 - 1, work, 0, ldwork, one, dArray, 1 + ib - 1 + (i + n2 - 1) * n4 + n3, n4 - 1);
                        }
                        Dsyrk.dsyrk("Upper", "Transpose", i3, ib, -one, work, 0, ldwork, one, dArray, n2 + 1 - 1 + (i + n2 - 1) * n4 + n3, n4 - 1);
                        jj = 1;
                        while (jj <= i3) {
                            Dpbtrf.ii.val = jj;
                            while (Dpbtrf.ii.val <= ib) {
                                dArray[Dpbtrf.ii.val - Dpbtrf.jj + 1 - 1 + (Dpbtrf.jj + Dpbtrf.i + n2 - 1 - 1) * n4 + n3] = work[Dpbtrf.ii.val - 1 + (jj - 1) * ldwork];
                                ++Dpbtrf.ii.val;
                            }
                            ++jj;
                        }
                    }
                }
                i += n5;
            }
            return;
        }
        j = 1;
        while (j <= nb) {
            i = j + 1;
            while (i <= nb) {
                Dpbtrf.work[Dpbtrf.i - 1 + (Dpbtrf.j - 1) * Dpbtrf.ldwork] = zero;
                ++i;
            }
            ++j;
        }
        int n6 = nb;
        i = 1;
        while (!(n6 < 0 ? i < n : i > n)) {
            ib = Math.min(nb, n - i + 1);
            Dpotf2.dpotf2(string, ib, dArray, (i - 1) * n4 + n3, n4 - 1, ii);
            if (Dpbtrf.ii.val != 0) {
                intW2.val = i + Dpbtrf.ii.val - 1;
                return;
            }
            if (i + ib <= n) {
                i2 = Math.min(n2 - ib, n - i - ib + 1);
                i3 = Math.min(ib, n - i - n2 + 1);
                if (i2 > 0) {
                    Dtrsm.dtrsm("Right", "Lower", "Transpose", "Non-unit", i2, ib, one, dArray, (i - 1) * n4 + n3, n4 - 1, dArray, 1 + ib - 1 + (i - 1) * n4 + n3, n4 - 1);
                    Dsyrk.dsyrk("Lower", "No Transpose", i2, ib, -one, dArray, 1 + ib - 1 + (i - 1) * n4 + n3, n4 - 1, one, dArray, (i + ib - 1) * n4 + n3, n4 - 1);
                }
                if (i3 > 0) {
                    jj = 1;
                    while (jj <= ib) {
                        Dpbtrf.ii.val = 1;
                        while (Dpbtrf.ii.val <= Math.min(jj, i3)) {
                            Dpbtrf.work[Dpbtrf.ii.val - 1 + (Dpbtrf.jj - 1) * Dpbtrf.ldwork] = dArray[n2 + 1 - jj + Dpbtrf.ii.val - 1 + (jj + i - 1 - 1) * n4 + n3];
                            ++Dpbtrf.ii.val;
                        }
                        ++jj;
                    }
                    Dtrsm.dtrsm("Right", "Lower", "Transpose", "Non-unit", i3, ib, one, dArray, (i - 1) * n4 + n3, n4 - 1, work, 0, ldwork);
                    if (i2 > 0) {
                        Dgemm.dgemm("No transpose", "Transpose", i3, i2, ib, -one, work, 0, ldwork, dArray, 1 + ib - 1 + (i - 1) * n4 + n3, n4 - 1, one, dArray, 1 + n2 - ib - 1 + (i + ib - 1) * n4 + n3, n4 - 1);
                    }
                    Dsyrk.dsyrk("Lower", "No Transpose", i3, ib, -one, work, 0, ldwork, one, dArray, (i + n2 - 1) * n4 + n3, n4 - 1);
                    jj = 1;
                    while (jj <= ib) {
                        Dpbtrf.ii.val = 1;
                        while (Dpbtrf.ii.val <= Math.min(jj, i3)) {
                            dArray[n2 + 1 - Dpbtrf.jj + Dpbtrf.ii.val - 1 + (Dpbtrf.jj + Dpbtrf.i - 1 - 1) * n4 + n3] = work[Dpbtrf.ii.val - 1 + (jj - 1) * ldwork];
                            ++Dpbtrf.ii.val;
                        }
                        ++jj;
                    }
                }
            }
            i += n6;
        }
    }

    static {
        nbmax = 32;
        ldwork = nbmax + 1;
        ii = new intW(0);
        work = new double[ldwork * nbmax];
    }
}

