/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dgemm;
import org.netlib.blas.Dsyrk;
import org.netlib.blas.Dtrsm;
import org.netlib.lapack.Dpotf2;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dpotrf {
    static double one = 1.0;
    static boolean upper;
    static int j;
    static int jb;
    static int nb;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dpotrf(String string, int n, double[] dArray, int n2, int n3, intW intW2) {
        block15: {
            intW2.val = 0;
            boolean bl = upper = string.toLowerCase().charAt(0) == "U".toLowerCase().charAt(0);
            if (!upper && string.toLowerCase().charAt(0) != "L".toLowerCase().charAt(0)) {
                intW2.val = -1;
            } else if (n < 0) {
                intW2.val = -2;
            } else if (n3 < Math.max(1, n)) {
                intW2.val = -4;
            }
            if (intW2.val != 0) {
                Xerbla.xerbla("DPOTRF", -intW2.val);
                return;
            }
            if (n == 0) {
                return;
            }
            nb = Ilaenv.ilaenv(1, "DPOTRF", string, n, -1, -1, -1);
            if (nb <= 1 || nb >= n) {
                Dpotf2.dpotf2(string, n, dArray, n2, n3, intW2);
                return;
            }
            if (upper) {
                int n4 = nb;
                j = 1;
                while (!(n4 < 0 ? j < n : j > n)) {
                    jb = Math.min(nb, n - j + 1);
                    Dsyrk.dsyrk("Upper", "Transpose", jb, j - 1, -one, dArray, (j - 1) * n3 + n2, n3, one, dArray, j - 1 + (j - 1) * n3 + n2, n3);
                    Dpotf2.dpotf2("Upper", jb, dArray, j - 1 + (j - 1) * n3 + n2, n3, intW2);
                    if (intW2.val != 0) {
                        break block15;
                    }
                    if (j + jb <= n) {
                        Dgemm.dgemm("Transpose", "No transpose", jb, n - j - jb + 1, j - 1, -one, dArray, (j - 1) * n3 + n2, n3, dArray, (j + jb - 1) * n3 + n2, n3, one, dArray, j - 1 + (j + jb - 1) * n3 + n2, n3);
                        Dtrsm.dtrsm("Left", "Upper", "Transpose", "Non-unit", jb, n - j - jb + 1, one, dArray, j - 1 + (j - 1) * n3 + n2, n3, dArray, j - 1 + (j + jb - 1) * n3 + n2, n3);
                    }
                    j += n4;
                }
                return;
            }
            int n5 = nb;
            j = 1;
            while (!(n5 < 0 ? j < n : j > n)) {
                jb = Math.min(nb, n - j + 1);
                Dsyrk.dsyrk("Lower", "No transpose", jb, j - 1, -one, dArray, j - 1 + 0 * n3 + n2, n3, one, dArray, j - 1 + (j - 1) * n3 + n2, n3);
                Dpotf2.dpotf2("Lower", jb, dArray, j - 1 + (j - 1) * n3 + n2, n3, intW2);
                if (intW2.val != 0) {
                    break block15;
                }
                if (j + jb <= n) {
                    Dgemm.dgemm("No transpose", "Transpose", n - j - jb + 1, jb, j - 1, -one, dArray, j + jb - 1 + 0 * n3 + n2, n3, dArray, j - 1 + 0 * n3 + n2, n3, one, dArray, j + jb - 1 + (j - 1) * n3 + n2, n3);
                    Dtrsm.dtrsm("Right", "Lower", "Transpose", "Non-unit", n - j - jb + 1, jb, one, dArray, j - 1 + (j - 1) * n3 + n2, n3, dArray, j + jb - 1 + (j - 1) * n3 + n2, n3);
                }
                j += n5;
            }
            return;
        }
        intW2.val = intW2.val + j - 1;
    }
}

