/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Daxpy;
import org.netlib.blas.Idamax;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dpttrs;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dptrfs {
    static int itmax = 5;
    static double zero;
    static double one;
    static double two;
    static double three;
    static int count;
    static int i;
    static int ix;
    static int j;
    static int nz;
    static double bi;
    static double cx;
    static double dx;
    static double eps;
    static double ex;
    static double lstres;
    static double s;
    static double safe1;
    static double safe2;
    static double safmin;

    public static void dptrfs(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, double[] dArray3, int n5, double[] dArray4, int n6, double[] dArray5, int n7, int n8, double[] dArray6, int n9, int n10, double[] dArray7, int n11, double[] dArray8, int n12, double[] dArray9, int n13, intW intW2) {
        intW2.val = 0;
        if (n < 0) {
            intW2.val = -1;
        } else if (n2 < 0) {
            intW2.val = -2;
        } else if (n8 < Math.max(1, n)) {
            intW2.val = -8;
        } else if (n10 < Math.max(1, n)) {
            intW2.val = -10;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DPTRFS", -intW2.val);
        } else if (n == 0 || n2 == 0) {
            j = 1;
            while (j <= n2) {
                dArray7[Dptrfs.j - 1 + n11] = zero;
                dArray8[Dptrfs.j - 1 + n12] = zero;
                ++j;
            }
        } else {
            nz = 4;
            eps = Dlamch.dlamch("Epsilon");
            safmin = Dlamch.dlamch("Safe minimum");
            safe1 = (double)nz * safmin;
            safe2 = safe1 / eps;
            j = 1;
            while (j <= n2) {
                count = 1;
                lstres = three;
                while (true) {
                    if (n == 1) {
                        bi = dArray5[(j - 1) * n8 + n7];
                        dx = dArray[n3] * dArray6[(j - 1) * n10 + n9];
                        dArray9[n + 1 - 1 + n13] = bi - dx;
                        dArray9[n13] = Math.abs(bi) + Math.abs(dx);
                    } else {
                        bi = dArray5[(j - 1) * n8 + n7];
                        dx = dArray[n3] * dArray6[(j - 1) * n10 + n9];
                        ex = dArray2[n4] * dArray6[1 + (j - 1) * n10 + n9];
                        dArray9[n + 1 - 1 + n13] = bi - dx - ex;
                        dArray9[n13] = Math.abs(bi) + Math.abs(dx) + Math.abs(ex);
                        i = 2;
                        while (i <= n - 1) {
                            bi = dArray5[i - 1 + (j - 1) * n8 + n7];
                            cx = dArray2[i - 1 - 1 + n4] * dArray6[i - 1 - 1 + (j - 1) * n10 + n9];
                            dx = dArray[i - 1 + n3] * dArray6[i - 1 + (j - 1) * n10 + n9];
                            ex = dArray2[i - 1 + n4] * dArray6[i + 1 - 1 + (j - 1) * n10 + n9];
                            dArray9[n + Dptrfs.i - 1 + n13] = bi - cx - dx - ex;
                            dArray9[Dptrfs.i - 1 + n13] = Math.abs(bi) + Math.abs(cx) + Math.abs(dx) + Math.abs(ex);
                            ++i;
                        }
                        bi = dArray5[n - 1 + (j - 1) * n8 + n7];
                        cx = dArray2[n - 1 - 1 + n4] * dArray6[n - 1 - 1 + (j - 1) * n10 + n9];
                        dx = dArray[n - 1 + n3] * dArray6[n - 1 + (j - 1) * n10 + n9];
                        dArray9[n + n - 1 + n13] = bi - cx - dx;
                        dArray9[n - 1 + n13] = Math.abs(bi) + Math.abs(cx) + Math.abs(dx);
                    }
                    s = zero;
                    i = 1;
                    while (i <= n) {
                        s = dArray9[i - 1 + n13] > safe2 ? Math.max(s, Math.abs(dArray9[n + i - 1 + n13]) / dArray9[i - 1 + n13]) : Math.max(s, (Math.abs(dArray9[n + i - 1 + n13]) + safe1) / (dArray9[i - 1 + n13] + safe1));
                        ++i;
                    }
                    dArray8[Dptrfs.j - 1 + n12] = s;
                    if (!(dArray8[j - 1 + n12] > eps) || !(two * dArray8[j - 1 + n12] <= lstres) || count > itmax) break;
                    Dpttrs.dpttrs(n, 1, dArray3, n5, dArray4, n6, dArray9, n + 1 - 1 + n13, n, intW2);
                    Daxpy.daxpy(n, one, dArray9, n + 1 - 1 + n13, 1, dArray6, (j - 1) * n10 + n9, 1);
                    lstres = dArray8[j - 1 + n12];
                    ++count;
                }
                i = 1;
                while (i <= n) {
                    dArray9[Dptrfs.i - 1 + n13] = dArray9[i - 1 + n13] > safe2 ? Math.abs(dArray9[n + i - 1 + n13]) + (double)nz * eps * dArray9[i - 1 + n13] : Math.abs(dArray9[n + i - 1 + n13]) + (double)nz * eps * dArray9[i - 1 + n13] + safe1;
                    ++i;
                }
                ix = Idamax.idamax(n, dArray9, n13, 1);
                dArray7[Dptrfs.j - 1 + n11] = dArray9[ix - 1 + n13];
                dArray9[n13] = one;
                i = 2;
                while (i <= n) {
                    dArray9[Dptrfs.i - 1 + n13] = one + dArray9[i - 1 - 1 + n13] * Math.abs(dArray4[i - 1 - 1 + n6]);
                    ++i;
                }
                dArray9[n - 1 + n13] = dArray9[n - 1 + n13] / dArray3[n - 1 + n5];
                int n14 = -1;
                i = n - 1;
                while (i >= 1) {
                    dArray9[Dptrfs.i - 1 + n13] = dArray9[i - 1 + n13] / dArray3[i - 1 + n5] + dArray9[i + 1 - 1 + n13] * Math.abs(dArray4[i - 1 + n6]);
                    i += n14;
                }
                ix = Idamax.idamax(n, dArray9, n13, 1);
                dArray7[Dptrfs.j - 1 + n11] = dArray7[j - 1 + n11] * Math.abs(dArray9[ix - 1 + n13]);
                lstres = zero;
                i = 1;
                while (i <= n) {
                    lstres = Math.max(lstres, Math.abs(dArray6[i - 1 + (j - 1) * n10 + n9]));
                    ++i;
                }
                if (lstres != zero) {
                    dArray7[Dptrfs.j - 1 + n11] = dArray7[j - 1 + n11] / lstres;
                }
                ++j;
            }
        }
    }

    static {
        one = 1.0;
        two = 2.0;
        three = 3.0;
    }
}

