/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlansb;
import org.netlib.lapack.Dlascl;
import org.netlib.lapack.Dsbtrd;
import org.netlib.lapack.Dsteqr;
import org.netlib.lapack.Dsterf;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dsbev {
    static double zero;
    static double one;
    static boolean lower;
    static boolean wantz;
    static intW iinfo;
    static int imax;
    static int inde;
    static int indwrk;
    static int iscale;
    static double anrm;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;

    public static void dsbev(String string, String string2, int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, double[] dArray3, int n6, int n7, double[] dArray4, int n8, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        lower = string2.toLowerCase().charAt(0) == "L".toLowerCase().charAt(0);
        intW2.val = 0;
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (!lower && string2.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0)) {
            intW2.val = -2;
        } else if (n < 0) {
            intW2.val = -3;
        } else if (n2 < 0) {
            intW2.val = -4;
        } else if (n4 < n2 + 1) {
            intW2.val = -6;
        } else if (n7 < 1 || wantz && n7 < n) {
            intW2.val = -9;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSBEV ", -intW2.val);
        } else if (n == 0) {
        } else if (n == 1) {
            dArray2[n5] = dArray[0 * n4 + n3];
            if (wantz) {
                dArray3[0 * n7 + n6] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            anrm = Dlansb.dlansb("M", string2, n, n2, dArray, n3, n4, dArray4, n8);
            iscale = 0;
            if (anrm > zero && anrm < rmin) {
                iscale = 1;
                sigma = rmin / anrm;
            } else if (anrm > rmax) {
                iscale = 1;
                sigma = rmax / anrm;
            }
            if (iscale == 1) {
                if (lower) {
                    Dlascl.dlascl("B", n2, n2, one, sigma, n, n, dArray, n3, n4, intW2);
                } else {
                    Dlascl.dlascl("Q", n2, n2, one, sigma, n, n, dArray, n3, n4, intW2);
                }
            }
            inde = 1;
            indwrk = inde + n;
            Dsbtrd.dsbtrd(string, string2, n, n2, dArray, n3, n4, dArray2, n5, dArray4, inde - 1 + n8, dArray3, n6, n7, dArray4, indwrk - 1 + n8, iinfo);
            if (!wantz) {
                Dsterf.dsterf(n, dArray2, n5, dArray4, inde - 1 + n8, intW2);
            } else {
                Dsteqr.dsteqr(string, n, dArray2, n5, dArray4, inde - 1 + n8, dArray3, n6, n7, dArray4, indwrk - 1 + n8, intW2);
            }
            if (iscale == 1) {
                imax = intW2.val == 0 ? n : intW2.val - 1;
                Dscal.dscal(imax, one / sigma, dArray2, n5, 1);
            }
        }
    }

    static {
        one = 1.0;
        iinfo = new intW(0);
    }
}

