/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dgemm;
import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlansb;
import org.netlib.lapack.Dlascl;
import org.netlib.lapack.Dsbtrd;
import org.netlib.lapack.Dstedc;
import org.netlib.lapack.Dsterf;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dsbevd {
    static double zero;
    static double one;
    static double two;
    static boolean lower;
    static boolean wantz;
    static intW iinfo;
    static int inde;
    static int indwk2;
    static int indwrk;
    static int iscale;
    static int lgn;
    static int liwmin;
    static int llwrk2;
    static int lwmin;
    static double anrm;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;

    public static void dsbevd(String string, String string2, int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, double[] dArray3, int n6, int n7, double[] dArray4, int n8, int n9, int[] nArray, int n10, int n11, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        lower = string2.toLowerCase().charAt(0) == "L".toLowerCase().charAt(0);
        intW2.val = 0;
        if (n <= 1) {
            lgn = 0;
            liwmin = 1;
            lwmin = 1;
        } else {
            lgn = (int)(Math.log(n) / Math.log(two));
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            if (wantz) {
                liwmin = 2 + 5 * n;
                lwmin = (int)((double)(1 + 4 * n + 2 * n * lgn) + 3.0 * Math.pow(n, 2.0));
            } else {
                liwmin = 1;
                lwmin = 2 * n;
            }
        }
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (!lower && string2.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0)) {
            intW2.val = -2;
        } else if (n < 0) {
            intW2.val = -3;
        } else if (n2 < 0) {
            intW2.val = -4;
        } else if (n4 < n2 + 1) {
            intW2.val = -6;
        } else if (n7 < 1 || wantz && n7 < n) {
            intW2.val = -9;
        } else if (n9 < lwmin) {
            intW2.val = -11;
        } else if (n11 < liwmin) {
            intW2.val = -13;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSBEVD ", -intW2.val);
        } else if (n == 0) {
        } else if (n == 1) {
            dArray2[n5] = dArray[0 * n4 + n3];
            if (wantz) {
                dArray3[0 * n7 + n6] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            anrm = Dlansb.dlansb("M", string2, n, n2, dArray, n3, n4, dArray4, n8);
            iscale = 0;
            if (anrm > zero && anrm < rmin) {
                iscale = 1;
                sigma = rmin / anrm;
            } else if (anrm > rmax) {
                iscale = 1;
                sigma = rmax / anrm;
            }
            if (iscale == 1) {
                if (lower) {
                    Dlascl.dlascl("B", n2, n2, one, sigma, n, n, dArray, n3, n4, intW2);
                } else {
                    Dlascl.dlascl("Q", n2, n2, one, sigma, n, n, dArray, n3, n4, intW2);
                }
            }
            inde = 1;
            indwrk = inde + n;
            indwk2 = indwrk + n * n;
            llwrk2 = n9 - indwk2 + 1;
            Dsbtrd.dsbtrd(string, string2, n, n2, dArray, n3, n4, dArray2, n5, dArray4, inde - 1 + n8, dArray3, n6, n7, dArray4, indwrk - 1 + n8, iinfo);
            if (!wantz) {
                Dsterf.dsterf(n, dArray2, n5, dArray4, inde - 1 + n8, intW2);
            } else {
                Dstedc.dstedc("I", n, dArray2, n5, dArray4, inde - 1 + n8, dArray4, indwrk - 1 + n8, n, dArray4, indwk2 - 1 + n8, llwrk2, nArray, n10, n11, intW2);
                Dgemm.dgemm("N", "N", n, n, n, one, dArray3, n6, n7, dArray4, indwrk - 1 + n8, n, zero, dArray4, indwk2 - 1 + n8, n);
                Dlacpy.dlacpy("A", n, n, dArray4, indwk2 - 1 + n8, n, dArray3, n6, n7);
            }
            if (iscale == 1) {
                Dscal.dscal(n, one / sigma, dArray2, n5, 1);
            }
        }
        if (n9 > 0) {
            dArray4[n8] = lwmin;
        }
        if (n11 > 0) {
            nArray[n10] = liwmin;
        }
    }

    static {
        one = 1.0;
        two = 2.0;
        iinfo = new intW(0);
    }
}

