/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlanst;
import org.netlib.lapack.Dsteqr;
import org.netlib.lapack.Dsterf;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dstev {
    static double zero;
    static double one;
    static boolean wantz;
    static int imax;
    static int iscale;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;
    static double tnrm;

    public static void dstev(String string, int n, double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, int n5, double[] dArray4, int n6, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        intW2.val = 0;
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (n < 0) {
            intW2.val = -2;
        } else if (n5 < 1 || wantz && n5 < n) {
            intW2.val = -6;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSTEV ", -intW2.val);
        } else if (n == 0) {
        } else if (n == 1) {
            if (wantz) {
                dArray3[0 * n5 + n4] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            iscale = 0;
            tnrm = Dlanst.dlanst("M", n, dArray, n2, dArray2, n3);
            if (tnrm > zero && tnrm < rmin) {
                iscale = 1;
                sigma = rmin / tnrm;
            } else if (tnrm > rmax) {
                iscale = 1;
                sigma = rmax / tnrm;
            }
            if (iscale == 1) {
                Dscal.dscal(n, sigma, dArray, n2, 1);
                Dscal.dscal(n - 1, sigma, dArray2, n3, 1);
            }
            if (!wantz) {
                Dsterf.dsterf(n, dArray, n2, dArray2, n3, intW2);
            } else {
                Dsteqr.dsteqr("I", n, dArray, n2, dArray2, n3, dArray3, n4, n5, dArray4, n6, intW2);
            }
            if (iscale == 1) {
                imax = intW2.val == 0 ? n : intW2.val - 1;
                Dscal.dscal(imax, one / sigma, dArray, n2, 1);
            }
        }
    }

    static {
        one = 1.0;
    }
}

