/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlanst;
import org.netlib.lapack.Dstedc;
import org.netlib.lapack.Dsterf;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dstevd {
    static double zero;
    static double one;
    static double two;
    static boolean wantz;
    static int iscale;
    static int lgn;
    static int liwmin;
    static int lwmin;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;
    static double tnrm;

    public static void dstevd(String string, int n, double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, int n5, double[] dArray4, int n6, int n7, int[] nArray, int n8, int n9, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        intW2.val = 0;
        liwmin = 1;
        lwmin = 1;
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (n < 0) {
            intW2.val = -2;
        } else if (n5 < 1 || wantz && n5 < n) {
            intW2.val = -6;
        } else if (n > 1 && wantz) {
            lgn = (int)(Math.log(n) / Math.log(two));
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            lwmin = (int)((double)(1 + 3 * n + 2 * n * lgn) + 2.0 * Math.pow(n, 2.0));
            liwmin = 2 + 5 * n;
            if (n7 < lwmin) {
                intW2.val = -8;
            } else if (n9 < liwmin) {
                intW2.val = -10;
            }
        } else if (n7 < 1) {
            intW2.val = -8;
        } else if (n9 < 1) {
            intW2.val = -10;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSTEVD", -intW2.val);
        } else if (n == 0) {
        } else if (n == 1) {
            if (wantz) {
                dArray3[0 * n5 + n4] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            iscale = 0;
            tnrm = Dlanst.dlanst("M", n, dArray, n2, dArray2, n3);
            if (tnrm > zero && tnrm < rmin) {
                iscale = 1;
                sigma = rmin / tnrm;
            } else if (tnrm > rmax) {
                iscale = 1;
                sigma = rmax / tnrm;
            }
            if (iscale == 1) {
                Dscal.dscal(n, sigma, dArray, n2, 1);
                Dscal.dscal(n - 1, sigma, dArray2, n3, 1);
            }
            if (!wantz) {
                Dsterf.dsterf(n, dArray, n2, dArray2, n3, intW2);
            } else {
                Dstedc.dstedc("I", n, dArray, n2, dArray2, n3, dArray3, n4, n5, dArray4, n6, n7, nArray, n8, n9, intW2);
            }
            if (iscale == 1) {
                Dscal.dscal(n, one / sigma, dArray, n2, 1);
            }
        }
        if (n7 > 0) {
            dArray4[n6] = lwmin;
        }
        if (n9 > 0) {
            nArray[n8] = liwmin;
        }
    }

    static {
        one = 1.0;
        two = 2.0;
    }
}

