/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlansy;
import org.netlib.lapack.Dlascl;
import org.netlib.lapack.Dorgtr;
import org.netlib.lapack.Dsteqr;
import org.netlib.lapack.Dsterf;
import org.netlib.lapack.Dsytrd;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dsyev {
    static double zero;
    static double one;
    static boolean lower;
    static boolean wantz;
    static intW iinfo;
    static int imax;
    static int inde;
    static int indtau;
    static int indwrk;
    static int iscale;
    static int llwork;
    static int lopt;
    static double anrm;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;

    public static void dsyev(String string, String string2, int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, double[] dArray3, int n5, int n6, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        lower = string2.toLowerCase().charAt(0) == "L".toLowerCase().charAt(0);
        intW2.val = 0;
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (!lower && string2.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0)) {
            intW2.val = -2;
        } else if (n < 0) {
            intW2.val = -3;
        } else if (n3 < Math.max(1, n)) {
            intW2.val = -5;
        } else if (n6 < Math.max(1, 3 * n - 1)) {
            intW2.val = -8;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSYEV ", -intW2.val);
        } else if (n == 0) {
            dArray3[n5] = 1.0;
        } else if (n == 1) {
            dArray2[n4] = dArray[0 * n3 + n2];
            dArray3[n5] = 3.0;
            if (wantz) {
                dArray[0 * n3 + n2] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            anrm = Dlansy.dlansy("M", string2, n, dArray, n2, n3, dArray3, n5);
            iscale = 0;
            if (anrm > zero && anrm < rmin) {
                iscale = 1;
                sigma = rmin / anrm;
            } else if (anrm > rmax) {
                iscale = 1;
                sigma = rmax / anrm;
            }
            if (iscale == 1) {
                Dlascl.dlascl(string2, 0, 0, one, sigma, n, n, dArray, n2, n3, intW2);
            }
            inde = 1;
            indtau = inde + n;
            indwrk = indtau + n;
            llwork = n6 - indwrk + 1;
            Dsytrd.dsytrd(string2, n, dArray, n2, n3, dArray2, n4, dArray3, inde - 1 + n5, dArray3, indtau - 1 + n5, dArray3, indwrk - 1 + n5, llwork, iinfo);
            lopt = (int)((double)(2 * n) + dArray3[indwrk - 1 + n5]);
            if (!wantz) {
                Dsterf.dsterf(n, dArray2, n4, dArray3, inde - 1 + n5, intW2);
            } else {
                Dorgtr.dorgtr(string2, n, dArray, n2, n3, dArray3, indtau - 1 + n5, dArray3, indwrk - 1 + n5, llwork, iinfo);
                Dsteqr.dsteqr(string, n, dArray2, n4, dArray3, inde - 1 + n5, dArray, n2, n3, dArray3, indtau - 1 + n5, intW2);
            }
            if (iscale == 1) {
                imax = intW2.val == 0 ? n : intW2.val - 1;
                Dscal.dscal(imax, one / sigma, dArray2, n4, 1);
            }
            dArray3[n5] = Math.max(3 * n - 1, lopt);
        }
    }

    static {
        one = 1.0;
        iinfo = new intW(0);
    }
}

