/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlamch;
import org.netlib.lapack.Dlansy;
import org.netlib.lapack.Dlascl;
import org.netlib.lapack.Dormtr;
import org.netlib.lapack.Dstedc;
import org.netlib.lapack.Dsterf;
import org.netlib.lapack.Dsytrd;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dsyevd {
    static double zero;
    static double one;
    static double two;
    static boolean lower;
    static boolean wantz;
    static intW iinfo;
    static int inde;
    static int indtau;
    static int indwk2;
    static int indwrk;
    static int iscale;
    static int lgn;
    static int liopt;
    static int liwmin;
    static int llwork;
    static int llwrk2;
    static int lopt;
    static int lwmin;
    static double anrm;
    static double bignum;
    static double eps;
    static double rmax;
    static double rmin;
    static double safmin;
    static double sigma;
    static double smlnum;

    public static void dsyevd(String string, String string2, int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, double[] dArray3, int n5, int n6, int[] nArray, int n7, int n8, intW intW2) {
        wantz = string.toLowerCase().charAt(0) == "V".toLowerCase().charAt(0);
        lower = string2.toLowerCase().charAt(0) == "L".toLowerCase().charAt(0);
        intW2.val = 0;
        if (n <= 1) {
            lgn = 0;
            liwmin = 1;
            lopt = lwmin = 1;
            liopt = liwmin;
        } else {
            lgn = (int)(Math.log(n) / Math.log(two));
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            if (Math.pow(2.0, lgn) < (double)n) {
                ++lgn;
            }
            if (wantz) {
                liwmin = 2 + 5 * n;
                lwmin = (int)((double)(1 + 5 * n + 2 * n * lgn) + 3.0 * Math.pow(n, 2.0));
            } else {
                liwmin = 1;
                lwmin = 2 * n + 1;
            }
            lopt = lwmin;
            liopt = liwmin;
        }
        if (!wantz && string.toLowerCase().charAt(0) != "N".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (!lower && string2.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0)) {
            intW2.val = -2;
        } else if (n < 0) {
            intW2.val = -3;
        } else if (n3 < Math.max(1, n)) {
            intW2.val = -5;
        } else if (n6 < lwmin) {
            intW2.val = -8;
        } else if (n8 < liwmin) {
            intW2.val = -10;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DSYEVD ", -intW2.val);
        } else if (n == 0) {
        } else if (n == 1) {
            dArray2[n4] = dArray[0 * n3 + n2];
            if (wantz) {
                dArray[0 * n3 + n2] = one;
            }
        } else {
            safmin = Dlamch.dlamch("Safe minimum");
            eps = Dlamch.dlamch("Precision");
            smlnum = safmin / eps;
            bignum = one / smlnum;
            rmin = Math.sqrt(smlnum);
            rmax = Math.sqrt(bignum);
            anrm = Dlansy.dlansy("M", string2, n, dArray, n2, n3, dArray3, n5);
            iscale = 0;
            if (anrm > zero && anrm < rmin) {
                iscale = 1;
                sigma = rmin / anrm;
            } else if (anrm > rmax) {
                iscale = 1;
                sigma = rmax / anrm;
            }
            if (iscale == 1) {
                Dlascl.dlascl(string2, 0, 0, one, sigma, n, n, dArray, n2, n3, intW2);
            }
            inde = 1;
            indtau = inde + n;
            indwrk = indtau + n;
            llwork = n6 - indwrk + 1;
            indwk2 = indwrk + n * n;
            llwrk2 = n6 - indwk2 + 1;
            Dsytrd.dsytrd(string2, n, dArray, n2, n3, dArray2, n4, dArray3, inde - 1 + n5, dArray3, indtau - 1 + n5, dArray3, indwrk - 1 + n5, llwork, iinfo);
            lopt = (int)((double)(2 * n) + dArray3[indwrk - 1 + n5]);
            if (!wantz) {
                Dsterf.dsterf(n, dArray2, n4, dArray3, inde - 1 + n5, intW2);
            } else {
                Dstedc.dstedc("I", n, dArray2, n4, dArray3, inde - 1 + n5, dArray3, indwrk - 1 + n5, n, dArray3, indwk2 - 1 + n5, llwrk2, nArray, n7, n8, intW2);
                Dormtr.dormtr("L", string2, "N", n, n, dArray, n2, n3, dArray3, indtau - 1 + n5, dArray3, indwrk - 1 + n5, n, dArray3, indwk2 - 1 + n5, llwrk2, iinfo);
                Dlacpy.dlacpy("A", n, n, dArray3, indwrk - 1 + n5, n, dArray, n2, n3);
                lopt = (int)Math.max((double)lopt, (double)(1 + 5 * n + 2 * n * lgn) + 3.0 * Math.pow(n, 2.0));
            }
            if (iscale == 1) {
                Dscal.dscal(n, one / sigma, dArray2, n4, 1);
            }
        }
        if (n6 > 0) {
            dArray3[n5] = lopt;
        }
        if (n8 > 0) {
            nArray[n7] = liopt;
        }
    }

    static {
        one = 1.0;
        two = 2.0;
        iinfo = new intW(0);
    }
}

