/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Drot;
import org.netlib.blas.Dscal;
import org.netlib.blas.Dswap;
import org.netlib.blas.Dsyr;
import org.netlib.blas.Idamax;
import org.netlib.lapack.Dlaev2;
import org.netlib.util.Xerbla;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Dsytf2 {
    static double zero;
    static double one;
    static double eight;
    static double sevten;
    static boolean upper;
    static int imax;
    static int jmax;
    static int k;
    static int kk;
    static int kp;
    static int kstep;
    static double absakk;
    static double alpha;
    static doubleW c;
    static double colmax;
    static doubleW r1;
    static doubleW r2;
    static double rowmax;
    static doubleW s;
    static double t;

    public static void dsytf2(String string, int n, double[] dArray, int n2, int n3, int[] nArray, int n4, intW intW2) {
        block51: {
            intW2.val = 0;
            boolean bl = upper = string.toLowerCase().charAt(0) == "U".toLowerCase().charAt(0);
            if (!upper && string.toLowerCase().charAt(0) != "L".toLowerCase().charAt(0)) {
                intW2.val = -1;
            } else if (n < 0) {
                intW2.val = -2;
            } else if (n3 < Math.max(1, n)) {
                intW2.val = -4;
            }
            if (intW2.val != 0) {
                Xerbla.xerbla("DSYTF2", -intW2.val);
            } else {
                alpha = (one + Math.sqrt(sevten)) / eight;
                if (upper) {
                    k = n;
                    while (true) {
                        if (k < 1) {
                            break block51;
                        }
                        kstep = 1;
                        absakk = Math.abs(dArray[k - 1 + (k - 1) * n3 + n2]);
                        if (k > 1) {
                            imax = Idamax.idamax(k - 1, dArray, (k - 1) * n3 + n2, 1);
                            colmax = Math.abs(dArray[imax - 1 + (k - 1) * n3 + n2]);
                        } else {
                            colmax = zero;
                        }
                        if (Math.max(absakk, colmax) == zero) {
                            if (intW2.val == 0) {
                                intW2.val = k;
                            }
                            kp = k;
                        } else {
                            if (absakk >= alpha * colmax) {
                                kp = k;
                            } else {
                                jmax = imax + Idamax.idamax(k - imax, dArray, imax - 1 + (imax + 1 - 1) * n3 + n2, n3);
                                rowmax = Math.abs(dArray[imax - 1 + (jmax - 1) * n3 + n2]);
                                if (imax > 1) {
                                    jmax = Idamax.idamax(imax - 1, dArray, (imax - 1) * n3 + n2, 1);
                                    rowmax = Math.max(rowmax, Math.abs(dArray[jmax - 1 + (imax - 1) * n3 + n2]));
                                }
                                if (absakk >= alpha * colmax * (colmax / rowmax)) {
                                    kp = k;
                                } else if (Math.abs(dArray[imax - 1 + (imax - 1) * n3 + n2]) >= alpha * rowmax) {
                                    kp = imax;
                                } else {
                                    kp = imax;
                                    kstep = 2;
                                }
                            }
                            kk = k - kstep + 1;
                            if (kp != kk) {
                                Dswap.dswap(kp - 1, dArray, (kk - 1) * n3 + n2, 1, dArray, (kp - 1) * n3 + n2, 1);
                                Dswap.dswap(kk - kp - 1, dArray, kp + 1 - 1 + (kk - 1) * n3 + n2, 1, dArray, kp - 1 + (kp + 1 - 1) * n3 + n2, n3);
                                t = dArray[kk - 1 + (kk - 1) * n3 + n2];
                                dArray[Dsytf2.kk - 1 + (Dsytf2.kk - 1) * n3 + n2] = dArray[kp - 1 + (kp - 1) * n3 + n2];
                                dArray[Dsytf2.kp - 1 + (Dsytf2.kp - 1) * n3 + n2] = t;
                                if (kstep == 2) {
                                    t = dArray[k - 1 - 1 + (k - 1) * n3 + n2];
                                    dArray[Dsytf2.k - 1 - 1 + (Dsytf2.k - 1) * n3 + n2] = dArray[kp - 1 + (k - 1) * n3 + n2];
                                    dArray[Dsytf2.kp - 1 + (Dsytf2.k - 1) * n3 + n2] = t;
                                }
                            }
                            if (kstep == 1) {
                                Dsytf2.r1.val = one / dArray[k - 1 + (k - 1) * n3 + n2];
                                Dsyr.dsyr(string, k - 1, -Dsytf2.r1.val, dArray, (k - 1) * n3 + n2, 1, dArray, n2, n3);
                                Dscal.dscal(k - 1, Dsytf2.r1.val, dArray, (k - 1) * n3 + n2, 1);
                            } else {
                                Dlaev2.dlaev2(dArray[k - 1 - 1 + (k - 1 - 1) * n3 + n2], dArray[k - 1 - 1 + (k - 1) * n3 + n2], dArray[k - 1 + (k - 1) * n3 + n2], r1, r2, c, s);
                                Dsytf2.r1.val = one / Dsytf2.r1.val;
                                Dsytf2.r2.val = one / Dsytf2.r2.val;
                                Drot.drot(k - 2, dArray, (k - 1 - 1) * n3 + n2, 1, dArray, (k - 1) * n3 + n2, 1, Dsytf2.c.val, Dsytf2.s.val);
                                Dsyr.dsyr(string, k - 2, -Dsytf2.r1.val, dArray, (k - 1 - 1) * n3 + n2, 1, dArray, n2, n3);
                                Dsyr.dsyr(string, k - 2, -Dsytf2.r2.val, dArray, (k - 1) * n3 + n2, 1, dArray, n2, n3);
                                Dscal.dscal(k - 2, Dsytf2.r1.val, dArray, (k - 1 - 1) * n3 + n2, 1);
                                Dscal.dscal(k - 2, Dsytf2.r2.val, dArray, (k - 1) * n3 + n2, 1);
                                Drot.drot(k - 2, dArray, (k - 1 - 1) * n3 + n2, 1, dArray, (k - 1) * n3 + n2, 1, Dsytf2.c.val, -Dsytf2.s.val);
                            }
                        }
                        if (kstep == 1) {
                            nArray[Dsytf2.k - 1 + n4] = kp;
                        } else {
                            nArray[Dsytf2.k - 1 + n4] = -kp;
                            nArray[Dsytf2.k - 1 - 1 + n4] = -kp;
                        }
                        k -= kstep;
                    }
                }
                k = 1;
                while (true) {
                    if (k > n) {
                        break;
                    }
                    kstep = 1;
                    absakk = Math.abs(dArray[k - 1 + (k - 1) * n3 + n2]);
                    if (k < n) {
                        imax = k + Idamax.idamax(n - k, dArray, k + 1 - 1 + (k - 1) * n3 + n2, 1);
                        colmax = Math.abs(dArray[imax - 1 + (k - 1) * n3 + n2]);
                    } else {
                        colmax = zero;
                    }
                    if (Math.max(absakk, colmax) == zero) {
                        if (intW2.val == 0) {
                            intW2.val = k;
                        }
                        kp = k;
                    } else {
                        if (absakk >= alpha * colmax) {
                            kp = k;
                        } else {
                            jmax = k - 1 + Idamax.idamax(imax - k, dArray, imax - 1 + (k - 1) * n3 + n2, n3);
                            rowmax = Math.abs(dArray[imax - 1 + (jmax - 1) * n3 + n2]);
                            if (imax < n) {
                                jmax = imax + Idamax.idamax(n - imax, dArray, imax + 1 - 1 + (imax - 1) * n3 + n2, 1);
                                rowmax = Math.max(rowmax, Math.abs(dArray[jmax - 1 + (imax - 1) * n3 + n2]));
                            }
                            if (absakk >= alpha * colmax * (colmax / rowmax)) {
                                kp = k;
                            } else if (Math.abs(dArray[imax - 1 + (imax - 1) * n3 + n2]) >= alpha * rowmax) {
                                kp = imax;
                            } else {
                                kp = imax;
                                kstep = 2;
                            }
                        }
                        kk = k + kstep - 1;
                        if (kp != kk) {
                            if (kp < n) {
                                Dswap.dswap(n - kp, dArray, kp + 1 - 1 + (kk - 1) * n3 + n2, 1, dArray, kp + 1 - 1 + (kp - 1) * n3 + n2, 1);
                            }
                            Dswap.dswap(kp - kk - 1, dArray, kk + 1 - 1 + (kk - 1) * n3 + n2, 1, dArray, kp - 1 + (kk + 1 - 1) * n3 + n2, n3);
                            t = dArray[kk - 1 + (kk - 1) * n3 + n2];
                            dArray[Dsytf2.kk - 1 + (Dsytf2.kk - 1) * n3 + n2] = dArray[kp - 1 + (kp - 1) * n3 + n2];
                            dArray[Dsytf2.kp - 1 + (Dsytf2.kp - 1) * n3 + n2] = t;
                            if (kstep == 2) {
                                t = dArray[k + 1 - 1 + (k - 1) * n3 + n2];
                                dArray[Dsytf2.k + 1 - 1 + (Dsytf2.k - 1) * n3 + n2] = dArray[kp - 1 + (k - 1) * n3 + n2];
                                dArray[Dsytf2.kp - 1 + (Dsytf2.k - 1) * n3 + n2] = t;
                            }
                        }
                        if (kstep == 1) {
                            if (k < n) {
                                Dsytf2.r1.val = one / dArray[k - 1 + (k - 1) * n3 + n2];
                                Dsyr.dsyr(string, n - k, -Dsytf2.r1.val, dArray, k + 1 - 1 + (k - 1) * n3 + n2, 1, dArray, k + 1 - 1 + (k + 1 - 1) * n3 + n2, n3);
                                Dscal.dscal(n - k, Dsytf2.r1.val, dArray, k + 1 - 1 + (k - 1) * n3 + n2, 1);
                            }
                        } else if (k < n - 1) {
                            Dlaev2.dlaev2(dArray[k - 1 + (k - 1) * n3 + n2], dArray[k + 1 - 1 + (k - 1) * n3 + n2], dArray[k + 1 - 1 + (k + 1 - 1) * n3 + n2], r1, r2, c, s);
                            Dsytf2.r1.val = one / Dsytf2.r1.val;
                            Dsytf2.r2.val = one / Dsytf2.r2.val;
                            Drot.drot(n - k - 1, dArray, k + 2 - 1 + (k - 1) * n3 + n2, 1, dArray, k + 2 - 1 + (k + 1 - 1) * n3 + n2, 1, Dsytf2.c.val, Dsytf2.s.val);
                            Dsyr.dsyr(string, n - k - 1, -Dsytf2.r1.val, dArray, k + 2 - 1 + (k - 1) * n3 + n2, 1, dArray, k + 2 - 1 + (k + 2 - 1) * n3 + n2, n3);
                            Dsyr.dsyr(string, n - k - 1, -Dsytf2.r2.val, dArray, k + 2 - 1 + (k + 1 - 1) * n3 + n2, 1, dArray, k + 2 - 1 + (k + 2 - 1) * n3 + n2, n3);
                            Dscal.dscal(n - k - 1, Dsytf2.r1.val, dArray, k + 2 - 1 + (k - 1) * n3 + n2, 1);
                            Dscal.dscal(n - k - 1, Dsytf2.r2.val, dArray, k + 2 - 1 + (k + 1 - 1) * n3 + n2, 1);
                            Drot.drot(n - k - 1, dArray, k + 2 - 1 + (k - 1) * n3 + n2, 1, dArray, k + 2 - 1 + (k + 1 - 1) * n3 + n2, 1, Dsytf2.c.val, -Dsytf2.s.val);
                        }
                    }
                    if (kstep == 1) {
                        nArray[Dsytf2.k - 1 + n4] = kp;
                    } else {
                        nArray[Dsytf2.k - 1 + n4] = -kp;
                        nArray[Dsytf2.k + 1 - 1 + n4] = -kp;
                    }
                    k += kstep;
                }
            }
        }
    }

    static {
        one = 1.0;
        eight = 8.0;
        sevten = 17.0;
        c = new doubleW(0.0);
        r1 = new doubleW(0.0);
        r2 = new doubleW(0.0);
        s = new doubleW(0.0);
    }
}

