/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dtrmm;
import org.netlib.blas.Dtrsm;
import org.netlib.lapack.Dtrti2;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.Xerbla;
import org.netlib.util.intW;

public class Dtrtri {
    static double one = 1.0;
    static double zero;
    static boolean nounit;
    static boolean upper;
    static int j;
    static int jb;
    static int nb;
    static int nn;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dtrtri(String string, String string2, int n, double[] dArray, int n2, int n3, intW intW2) {
        intW2.val = 0;
        upper = string.toLowerCase().charAt(0) == "U".toLowerCase().charAt(0);
        boolean bl = nounit = string2.toLowerCase().charAt(0) == "N".toLowerCase().charAt(0);
        if (!upper && string.toLowerCase().charAt(0) != "L".toLowerCase().charAt(0)) {
            intW2.val = -1;
        } else if (!nounit && string2.toLowerCase().charAt(0) != "U".toLowerCase().charAt(0)) {
            intW2.val = -2;
        } else if (n < 0) {
            intW2.val = -3;
        } else if (n3 < Math.max(1, n)) {
            intW2.val = -5;
        }
        if (intW2.val != 0) {
            Xerbla.xerbla("DTRTRI", -intW2.val);
            return;
        }
        if (n == 0) {
            return;
        }
        if (nounit) {
            intW2.val = 1;
            while (intW2.val <= n) {
                if (dArray[intW2.val - 1 + (intW2.val - 1) * n3 + n2] == zero) {
                    return;
                }
                ++intW2.val;
            }
            intW2.val = 0;
        }
        if ((nb = Ilaenv.ilaenv(1, "DTRTRI", String.valueOf(string) + string2, n, -1, -1, -1)) <= 1 || nb >= n) {
            Dtrti2.dtrti2(string, string2, n, dArray, n2, n3, intW2);
            return;
        } else {
            if (upper) {
                int n4 = nb;
                j = 1;
                while (!(n4 < 0 ? j < n : j > n)) {
                    jb = Math.min(nb, n - j + 1);
                    Dtrmm.dtrmm("Left", "Upper", "No transpose", string2, j - 1, jb, one, dArray, n2, n3, dArray, (j - 1) * n3 + n2, n3);
                    Dtrsm.dtrsm("Right", "Upper", "No transpose", string2, j - 1, jb, -one, dArray, j - 1 + (j - 1) * n3 + n2, n3, dArray, (j - 1) * n3 + n2, n3);
                    Dtrti2.dtrti2("Upper", string2, jb, dArray, j - 1 + (j - 1) * n3 + n2, n3, intW2);
                    j += n4;
                }
                return;
            }
            nn = (n - 1) / nb * nb + 1;
            int n5 = -nb;
            j = nn;
            while (!(n5 < 0 ? j < 1 : j > 1)) {
                jb = Math.min(nb, n - j + 1);
                if (j + jb <= n) {
                    Dtrmm.dtrmm("Left", "Lower", "No transpose", string2, n - j - jb + 1, jb, one, dArray, j + jb - 1 + (j + jb - 1) * n3 + n2, n3, dArray, j + jb - 1 + (j - 1) * n3 + n2, n3);
                    Dtrsm.dtrsm("Right", "Lower", "No transpose", string2, n - j - jb + 1, jb, -one, dArray, j - 1 + (j - 1) * n3 + n2, n3, dArray, j + jb - 1 + (j - 1) * n3 + n2, n3);
                }
                Dtrti2.dtrti2("Lower", string2, jb, dArray, j - 1 + (j - 1) * n3 + n2, n3, intW2);
                j += n5;
            }
            return;
        }
    }
}

