#####################################################################
#
# meshtest.py
#
# Copyright (c) 2015, Eran Egozy
#
# Released under the MIT License (http://opensource.org/licenses/MIT)
#
#####################################################################


import sys
sys.path.append('..')
from common.core import *
from common.modifier import Modifier
from common.gfxutil import *

from kivy.core.window import Window
from kivy.clock import Clock as kivyClock
from kivy.uix.label import Label
from kivy.graphics import Color, Mesh
from kivy.core.image import Image

import numpy as np

##############################################################################


class MainWidget(BaseWidget) :
    def __init__(self):
        super(MainWidget, self).__init__()
        self.info = topleft_label()
        self.add_widget(self.info)

        self.modifier = Modifier()
        self.modifier.add('q', 'segments', (4,8,16,32,64,128,256,512), self._set_segments)
        self.modifier.add('w', 'bitmap', (False, True), self._use_bitmap)
        self.modifier.add('e', 'mode', ('triangle_strip','lines','line_strip'), self._set_mode)
        self.modifier.add('r', 'clr', ((1,1,1), (1,0,0), (0,1,0), (0,0,1)), self._set_color)

        # note how changing the color affects the texture - color is multiplied by
        # the color in each texel.
        c = (1.0, 1.0, 1.0, 1.0)
        clr = Color(*c)
        self.canvas.add(clr)

        # of segments changes the smoothness of the curve
        self.segments = 4
        self.use_bitmap = False
        self.tex_file = 'red_rect.png'
        self.mesh_mode = 'triangle_strip'

        self.color = Color(1,1,1,1)
        self.canvas.add(self.color)
        self.mesh = Mesh()
        self.canvas.add(self.mesh)

        self.update_mesh()

        self.time = 0

    def _set_segments(self, x) :
        self.segments = x
        self.update_mesh()

    def _use_bitmap(self, x) :
        self.use_bitmap = x
        if self.use_bitmap:
            self.mesh.texture = Image(self.tex_file).texture
        else:
            self.mesh.texture = None

    def _set_mode(self, x) :
        self.mesh_mode = x
        self.mesh.mode = self.mesh_mode

    def _set_color(self, x) :
        self.color.rgb = x

    def on_key_down(self, keycode, modifier):
        self.modifier.on_key_down(keycode[1])

    def on_key_up(self, keycode):
        self.modifier.on_key_up(keycode[1])

    def on_update(self):
        self.modifier.on_update()

        self.info.text = '\nfps:%d\n' % kivyClock.get_fps()
        self.info.text += self.modifier.get_txt()

        # animate a sine wave by setting the vert positions every frame:
        theta = 3.0 * self.time
        y = Window.height * (.35 + .1 * np.sin (np.linspace(theta, theta + 2 * np.pi, self.segments + 1)))
        self.mesh.vertices[5::8] = y

        # seems that you have to reassign the entire verts list in order for the change
        # to take effect.
        self.mesh.vertices = self.mesh.vertices

        self.time += kivyClock.frametime

    # a ribbon mesh has a matrix of verticies layed out as 2 x N+1 (rows x columns)
    # where N is the # of segments.
    def update_mesh(self):

        # size, location
        x, y, w, h = 100, 100, Window.width * .75, Window.height * .5

        # create indicies
        self.mesh.indices = range(self.segments * 2 + 2)

        # create verticies with evenly spaced texture coordinates
        span = np.linspace(0.0, 1.0, self.segments + 1)
        verts = []
        for s in span:
            verts += [x + s * w, y, s, 0,  x + s * w, y+h, s, 1]
        self.mesh.vertices = verts

        # mesh draw mode
        self.mesh.mode = self.mesh_mode

run(MainWidget)
