#####################################################################
#
# more_primatives.py
#
# Copyright (c) 2016, Eran Egozy
#
# Released under the MIT License (http://opensource.org/licenses/MIT)
#
#####################################################################

import sys
sys.path.append('..')
from common.core import *
from common.gfxutil import *

from kivy.core.window import Window
from kivy.clock import Clock as kivyClock
from kivy.graphics import Color, Ellipse, Rectangle, Line
from kivy.core.image import Image

from random import random, randint


class MainWidget(BaseWidget):
    def __init__(self, **kwargs):
        super(MainWidget, self).__init__(**kwargs)

        self.info = topleft_label()
        self.add_widget(self.info)

        # color with hsv and Rectangle
        self.canvas.add(Color(.2, 1, 1, mode='hsv'))
        self.canvas.add(Rectangle(pos=(100, 100), size=(100, 200)))

        # colors with alpha blending
        for i in range(4):
            self.canvas.add(Color(random(), random(), random(), .5))
            self.canvas.add(Rectangle(pos=(150 + 15 * i, 100 + 15 * i), size=(100, 100)))

        # lines
        self.canvas.add(Color(1, 0, 0))
        pts = [200 + random() * 200 for i in range(16)]
        self.canvas.add(Line(points = pts, width = 2))

        self.canvas.add(Color(0, 1, 0))
        # lines with bezier curvers
        self.canvas.add(Line(bezier = [100, 400, 100, 500, 600, 250, 700, 500], width = 5))

        # rectangle with a texture / image file.
        self.canvas.add(Color(1,1,1))
        self.canvas.add(Rectangle(pos=(200, 500), size=(100, 100), texture=Image('smiley.png').texture))


    def on_update(self):
        # update info
        self.info.text = '\nfps:%d' % kivyClock.get_fps()


# pass in which MainWidget to run as a command-line arg
run(MainWidget)
