#####################################################################
#
# moving_dots.py
#
# Copyright (c) 2015, Eran Egozy
#
# Released under the MIT License (http://opensource.org/licenses/MIT)
#
#####################################################################


import sys
sys.path.append('..')
from common.core import *
from common.gfxutil import *

from kivy.core.window import Window
from kivy.clock import Clock as kivyClock
from kivy.uix.label import Label
from kivy.graphics import Color, Line

import numpy as np


# A simple drawable dot that moves across the screen at a constant
# randomly chosen velocity
class Dot(Rectangle) :
    def __init__(self):
        super(Dot, self).__init__(size=(5,5), pos=(-10,-10))
        self.time = 0
        self.vel = np.random.random(2) * 200 - 100
        self.xy = np.random.random(2) * (Window.width, Window.height)

    def on_update(self, dt) :
        self.xy += self.vel * dt
        self.xy = np.mod(self.xy, (Window.width, Window.height))
        self.time += dt
        self.pos = self.xy - 2
        return True


class MainWidget(BaseWidget) :
    def __init__(self):
        super(MainWidget, self).__init__()
        self.info = topleft_label()
        self.add_widget(self.info)
        self.pause = False
        self.recent_num_lines = 0

        self.dist = 5000
        # add a bunch of dots and a bunch of lines.
        # animating dots and lines happens in on_update()
        num_dots = 300 / 3
        num_lines = 200

        self.canvas.add(Color(.6,1,.6,1))
        self.dots = [Dot() for n in range(num_dots)]
        for x in self.dots:
            self.canvas.add(x)

        self.canvas.add(Color(0,1,0,.5))
        self.lines = [ Line(width=1) for n in range(num_lines) ]
        for x in self.lines:
            self.canvas.add(x)


    def on_key_down(self, keycode, modifiers) :
        # pause
        if keycode[1] == 'spacebar':
            self.pause = not self.pause


    def on_update(self):
        # useful info to print
        self.info.text = str(Window.mouse_pos)
        self.info.text += '\nfps:%d' % kivyClock.get_fps()
        self.info.text += '\nlines:%d' % self.recent_num_lines

        # pause
        if self.pause:
            return

        # update dots (kivyClock.frametime is the delta-time since last frame)
        for d in self.dots:
            d.on_update(kivyClock.frametime)

        # the code below will configure lines in the scene. Reset the line
        # counter here
        self.line_cnt = 0

        # go through all pairs of dots, and draw a line of the dots are close enough
        num_dots = len(self.dots)
        for i1 in xrange(0, num_dots-1) :
            d1 = self.dots[i1]

            for i2 in xrange(i1+1, num_dots) :
                d2 = self.dots[i2]

                dd = d2.xy - d1.xy
                dd = dd.dot(dd)
                if dd < self.dist:
                    self._add_line(d1.xy, d2.xy)

        # show total lines drawn in our stats:
        self.recent_num_lines = self.line_cnt

        # hide the extra lines not needed this frame
        while self._add_line((-1,-1), (-1,-1)):
            pass


    # add a line if possible. return True if line was added.
    # return False if line was not added.
    def _add_line(self, pt1, pt2) :
        if self.line_cnt < len(self.lines):
            line = self.lines[self.line_cnt]
            line.points=[pt1[0], pt1[1], pt2[0], pt2[1]]
            self.line_cnt += 1
            return True
        else:
            return False


run(MainWidget)
